/*
 * Copyright 2017-present Open Networking Laboratory
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.check;

import java.util.List;
import org.onosproject.yang.gen.v1.check.check.Cont50;
import org.onosproject.yang.gen.v1.check.check.Cont53;
import org.onosproject.yang.gen.v1.check.check.List52;
import org.onosproject.yang.gen.v1.check.check.List56;

/**
 * Abstraction of an entity which represents the functionality of check.
 */
public interface Check {

    /**
     * Returns the attribute cont50.
     *
     * @return cont50 value of cont50
     */
    Cont50 cont50();

    /**
     * Returns the attribute list52.
     *
     * @return list52 list of list52
     */
    List<List52> list52();

    /**
     * Returns the attribute cont53.
     *
     * @return cont53 value of cont53
     */
    Cont53 cont53();

    /**
     * Returns the attribute list56.
     *
     * @return list56 list of list56
     */
    List<List56> list56();

    /**
     * Sets the attribute cont50.
     *
     * @param cont50 value of cont50
     */
    void cont50(Cont50 cont50);

    /**
     * Sets the attribute list52.
     *
     * @param list52 list of list52
     */
    void list52(List<List52> list52);

    /**
     * Sets the attribute cont53.
     *
     * @param cont53 value of cont53
     */
    void cont53(Cont53 cont53);

    /**
     * Sets the attribute list56.
     *
     * @param list56 list of list56
     */
    void list56(List<List56> list56);

    /**
     * Adds to the list of list52.
     *
     * @param addTo value of list52
     */
    void addToList52(List52 addTo);

    /**
     * Adds to the list of list56.
     *
     * @param addTo value of list56
     */
    void addToList56(List56 addTo);

}