/*
 * Copyright 2017-present Open Networking Laboratory
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.check.check.list56.cont56.augmentedcont56;

import java.util.BitSet;
import java.util.List;
import org.onosproject.yang.gen.v1.check.check.group1.Cont58;
import org.onosproject.yang.gen.v1.check.check.group1.List57;
import org.onosproject.yang.model.Augmentable;

/**
 * Abstraction of an entity which represents the functionality of cont57.
 */
public interface Cont57 extends Augmentable  {

    /**
     * Identify the leaf of Cont57.
     */
    public enum LeafIdentifier implements org.onosproject.yang.model.LeafIdentifier{
        /**
         * Represents cl57.
         */
        CL57(1);

        private int leafIndex;

        public int getLeafIndex() {
            return leafIndex;
        }

        LeafIdentifier(int value) {
            this.leafIndex = value;
        }
    }

    /**
     * Returns the attribute cl57.
     *
     * @return cl57 value of cl57
     */
    int cl57();

    /**
     * Returns the attribute valueLeafFlags.
     *
     * @return valueLeafFlags value of valueLeafFlags
     */
    BitSet valueLeafFlags();

    /**
     * Returns the attribute cont58.
     *
     * @return cont58 value of cont58
     */
    Cont58 cont58();

    /**
     * Returns the attribute list57.
     *
     * @return list57 list of list57
     */
    List<List57> list57();

    /**
     * Sets the attribute cl57.
     *
     * @param cl57 value of cl57
     */
    void cl57(int cl57);

    /**
     * Sets the attribute cont58.
     *
     * @param cont58 value of cont58
     */
    void cont58(Cont58 cont58);

    /**
     * Sets the attribute list57.
     *
     * @param list57 list of list57
     */
    void list57(List<List57> list57);

    /**
     * Adds to the list of list57.
     *
     * @param addTo value of list57
     */
    void addToList57(List57 addTo);


    /**
     * Checks if the leaf value is set.
     *
     * @param leaf leaf whose value status needs to checked
     * @return result of leaf value set in object
     */
    boolean isLeafValueSet(LeafIdentifier leaf);
}