/*
 * Copyright 2017-present Open Networking Laboratory
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.check.rev20151208.check;

import java.util.BitSet;
import java.util.Objects;
import java.util.StringJoiner;
import org.onosproject.yang.gen.v1.check.rev20151208.check.networks.Network;
import org.onosproject.yang.model.InnerModelObject;

/**
 * Represents the implementation of networks.
 *
 * <p>
 * valueLeafFlags identify the leafs whose value are explicitly set
 * Applicable in protocol edit and query operation.
 * </p>
 */
public class DefaultNetworks extends InnerModelObject implements Networks {
    protected int id;
    protected BitSet valueLeafFlags = new BitSet();
    protected Network network;

    @Override
    public int id() {
        return id;
    }

    @Override
    public BitSet valueLeafFlags() {
        return valueLeafFlags;
    }

    @Override
    public Network network() {
        return network;
    }

    @Override
    public void id(int id) {
        valueLeafFlags.set(LeafIdentifier.ID.getLeafIndex());
        this.id = id;
    }

    @Override
    public void network(Network network) {
        this.network = network;
    }

    @Override
    public int hashCode() {
        return Objects.hash(id, valueLeafFlags, network);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof DefaultNetworks) {
            DefaultNetworks other = (DefaultNetworks) obj;
            return
                Objects.equals(id, other.id) &&
                Objects.equals(valueLeafFlags, other.valueLeafFlags) &&
                Objects.equals(network, other.network);
        }
        return false;
    }

    @Override
    public String toString() {
        return new StringJoiner(", ", getClass().getSimpleName() +"{", "}")
            .add("id=" + id)
            .add("valueLeafFlags=" + valueLeafFlags)
            .add("network=" + network)
            .toString();
    }


    /**
     * Creates an instance of defaultNetworks.
     */
    public DefaultNetworks() {
    }


    @Override
    public boolean isLeafValueSet(LeafIdentifier leaf) {
        return valueLeafFlags.get(leaf.getLeafIndex());
    }

}