/*
 * Copyright 2017-present Open Networking Laboratory
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.ietfl3vpnsvc.rev20160730.ietfl3vpnsvc;

/**
 * Represents the implementation of multipoint.
 */
public abstract class Multipoint extends SiteNetworkAccessType {

    /**
     * Returns the attribute multipoint.
     *
     * @return multipoint value of multipoint
     */
    public static String multipointToString() {
        return "multipoint";
    }

    /**
     * Returns the object of multipoint fromString input String multipoint.
     *
     * @param valInString value of input String
     * @return multipoint
     */
    public static Class fromString(String valInString) {
        if (valInString.equals("multipoint")) {
            return Multipoint.class;
        }
        throw new IllegalArgumentException("not a valid input element");
    }
}