/*
 * Copyright 2017-present Open Networking Laboratory
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.ietfl3vpnsvc.rev20160730.ietfl3vpnsvc.accessdiversity;

import java.util.Objects;
import java.util.StringJoiner;
import org.onosproject.yang.gen.v1.ietfl3vpnsvc.rev20160730.ietfl3vpnsvc.accessdiversity.accessdiversity.Constraints;
import org.onosproject.yang.gen.v1.ietfl3vpnsvc.rev20160730.ietfl3vpnsvc.accessdiversity.accessdiversity.Groups;
import org.onosproject.yang.model.InnerModelObject;

/**
 * Represents the implementation of accessDiversity.
 *
 * <p>
 * valueLeafFlags identify the leafs whose value are explicitly set
 * Applicable in protocol edit and query operation.
 * </p>
 */
public class DefaultAccessDiversity extends InnerModelObject implements AccessDiversity {
    protected Groups groups;
    protected Constraints constraints;

    @Override
    public Groups groups() {
        return groups;
    }

    @Override
    public Constraints constraints() {
        return constraints;
    }

    @Override
    public void groups(Groups groups) {
        this.groups = groups;
    }

    @Override
    public void constraints(Constraints constraints) {
        this.constraints = constraints;
    }

    @Override
    public int hashCode() {
        return Objects.hash(groups, constraints);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof DefaultAccessDiversity) {
            DefaultAccessDiversity other = (DefaultAccessDiversity) obj;
            return
                Objects.equals(groups, other.groups) &&
                Objects.equals(constraints, other.constraints);
        }
        return false;
    }

    @Override
    public String toString() {
        return new StringJoiner(", ", getClass().getSimpleName() +"{", "}")
            .add("groups=" + groups)
            .add("constraints=" + constraints)
            .toString();
    }


    /**
     * Creates an instance of defaultAccessDiversity.
     */
    public DefaultAccessDiversity() {
    }

}