/*
 * Copyright 2017-present Open Networking Laboratory
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.ietfl3vpnsvc.rev20160730.ietfl3vpnsvc.accessdiversity.accessdiversity.constraints.constraint.target.targetflavor.id;

import java.lang.String;
import org.onosproject.yang.model.KeyInfo;
import java.util.Objects;

/**
 * Represents the implementation of group.
 */
public class GroupKeys implements KeyInfo<DefaultGroup> {
    protected String groupId;
    /**
     * Returns the attribute groupId.
     *
     * @return groupId value of groupId
     */
    public String groupId() {
        return groupId;
    }

    /**
     * Sets the value to attribute groupId.
     *
     * @param groupId value of groupId
     */
    public void groupId(String groupId) {
        this.groupId = groupId;
    }


    @Override
    public int hashCode() {
        return Objects.hash(groupId);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof GroupKeys) {
            GroupKeys other = (GroupKeys) obj;
            return
                Objects.equals(groupId, other.groupId);
        }
        return false;
    }
}