/*
 * Copyright 2017-present Open Networking Laboratory
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.ietfl3vpnsvc.rev20160730.ietfl3vpnsvc.l3vpnsvc.sites.site.sitenetworkaccesses;

import java.util.BitSet;
import java.util.Objects;
import java.util.StringJoiner;
import org.onosproject.yang.gen.v1.ietfl3vpnsvc.rev20160730.ietfl3vpnsvc.SiteNetworkAccessType;
import org.onosproject.yang.gen.v1.ietfl3vpnsvc.rev20160730.ietfl3vpnsvc.SvcId;
import org.onosproject.yang.gen.v1.ietfl3vpnsvc.rev20160730.ietfl3vpnsvc.accessdiversity.AccessDiversity;
import org.onosproject.yang.gen.v1.ietfl3vpnsvc.rev20160730.ietfl3vpnsvc.accessvpnpolicy.VpnAttachment;
import org.onosproject.yang.gen.v1.ietfl3vpnsvc.rev20160730.ietfl3vpnsvc.siteattachmentavailability.Availability;
import org.onosproject.yang.gen.v1.ietfl3vpnsvc.rev20160730.ietfl3vpnsvc.siteattachmentbearer.Bearer;
import org.onosproject.yang.gen.v1.ietfl3vpnsvc.rev20160730.ietfl3vpnsvc.siteattachmentipconnection.IpConnection;
import org.onosproject.yang.gen.v1.ietfl3vpnsvc.rev20160730.ietfl3vpnsvc.siterouting.RoutingProtocols;
import org.onosproject.yang.gen.v1.ietfl3vpnsvc.rev20160730.ietfl3vpnsvc.sitesecurity.Security;
import org.onosproject.yang.gen.v1.ietfl3vpnsvc.rev20160730.ietfl3vpnsvc.siteservice.Service;
import org.onosproject.yang.model.InnerModelObject;
import org.onosproject.yang.model.MultiInstanceObject;

/**
 * Represents the implementation of siteNetworkAccess.
 *
 * <p>
 * valueLeafFlags identify the leafs whose value are explicitly set
 * Applicable in protocol edit and query operation.
 * </p>
 */
public class DefaultSiteNetworkAccess extends InnerModelObject 
        implements SiteNetworkAccess, MultiInstanceObject<SiteNetworkAccessKeys> {
    protected SvcId siteNetworkAccessId;
    protected Class<? extends SiteNetworkAccessType> siteNetworkAccessType;
    protected BitSet valueLeafFlags = new BitSet();
    protected AccessDiversity accessDiversity;
    protected Bearer bearer;
    protected IpConnection ipConnection;
    protected Security security;
    protected Service service;
    protected RoutingProtocols routingProtocols;
    protected Availability availability;
    protected VpnAttachment vpnAttachment;

    @Override
    public SvcId siteNetworkAccessId() {
        return siteNetworkAccessId;
    }

    @Override
    public Class<? extends SiteNetworkAccessType> siteNetworkAccessType() {
        return siteNetworkAccessType;
    }

    @Override
    public BitSet valueLeafFlags() {
        return valueLeafFlags;
    }

    @Override
    public AccessDiversity accessDiversity() {
        return accessDiversity;
    }

    @Override
    public Bearer bearer() {
        return bearer;
    }

    @Override
    public IpConnection ipConnection() {
        return ipConnection;
    }

    @Override
    public Security security() {
        return security;
    }

    @Override
    public Service service() {
        return service;
    }

    @Override
    public RoutingProtocols routingProtocols() {
        return routingProtocols;
    }

    @Override
    public Availability availability() {
        return availability;
    }

    @Override
    public VpnAttachment vpnAttachment() {
        return vpnAttachment;
    }

    @Override
    public void siteNetworkAccessId(SvcId siteNetworkAccessId) {
        valueLeafFlags.set(LeafIdentifier.SITENETWORKACCESSID.getLeafIndex());
        this.siteNetworkAccessId = siteNetworkAccessId;
    }

    @Override
    public void siteNetworkAccessType(Class<? extends SiteNetworkAccessType> siteNetworkAccessType) {
        valueLeafFlags.set(LeafIdentifier.SITENETWORKACCESSTYPE.getLeafIndex());
        this.siteNetworkAccessType = siteNetworkAccessType;
    }

    @Override
    public void accessDiversity(AccessDiversity accessDiversity) {
        this.accessDiversity = accessDiversity;
    }

    @Override
    public void bearer(Bearer bearer) {
        this.bearer = bearer;
    }

    @Override
    public void ipConnection(IpConnection ipConnection) {
        this.ipConnection = ipConnection;
    }

    @Override
    public void security(Security security) {
        this.security = security;
    }

    @Override
    public void service(Service service) {
        this.service = service;
    }

    @Override
    public void routingProtocols(RoutingProtocols routingProtocols) {
        this.routingProtocols = routingProtocols;
    }

    @Override
    public void availability(Availability availability) {
        this.availability = availability;
    }

    @Override
    public void vpnAttachment(VpnAttachment vpnAttachment) {
        this.vpnAttachment = vpnAttachment;
    }

    @Override
    public int hashCode() {
        return Objects.hash(siteNetworkAccessId, siteNetworkAccessType, valueLeafFlags, accessDiversity, bearer, ipConnection, security, service, routingProtocols, availability, vpnAttachment);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof DefaultSiteNetworkAccess) {
            DefaultSiteNetworkAccess other = (DefaultSiteNetworkAccess) obj;
            return
                Objects.equals(siteNetworkAccessId, other.siteNetworkAccessId) &&
                Objects.equals(siteNetworkAccessType, other.siteNetworkAccessType) &&
                Objects.equals(valueLeafFlags, other.valueLeafFlags) &&
                Objects.equals(accessDiversity, other.accessDiversity) &&
                Objects.equals(bearer, other.bearer) &&
                Objects.equals(ipConnection, other.ipConnection) &&
                Objects.equals(security, other.security) &&
                Objects.equals(service, other.service) &&
                Objects.equals(routingProtocols, other.routingProtocols) &&
                Objects.equals(availability, other.availability) &&
                Objects.equals(vpnAttachment, other.vpnAttachment);
        }
        return false;
    }

    @Override
    public String toString() {
        return new StringJoiner(", ", getClass().getSimpleName() +"{", "}")
            .add("siteNetworkAccessId=" + siteNetworkAccessId)
            .add("siteNetworkAccessType=" + siteNetworkAccessType)
            .add("valueLeafFlags=" + valueLeafFlags)
            .add("accessDiversity=" + accessDiversity)
            .add("bearer=" + bearer)
            .add("ipConnection=" + ipConnection)
            .add("security=" + security)
            .add("service=" + service)
            .add("routingProtocols=" + routingProtocols)
            .add("availability=" + availability)
            .add("vpnAttachment=" + vpnAttachment)
            .toString();
    }


    /**
     * Creates an instance of defaultSiteNetworkAccess.
     */
    public DefaultSiteNetworkAccess() {
    }


    @Override
    public boolean isLeafValueSet(LeafIdentifier leaf) {
        return valueLeafFlags.get(leaf.getLeafIndex());
    }

}