/*
 * Copyright 2017-present Open Networking Laboratory
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.ietfl3vpnsvc.rev20160730.ietfl3vpnsvc.sitemaximumroutes.maximumroutes;

import java.util.BitSet;
import java.util.Objects;
import java.util.StringJoiner;
import org.onosproject.yang.model.InnerModelObject;
import org.onosproject.yang.model.MultiInstanceObject;

/**
 * Represents the implementation of addressFamily.
 *
 * <p>
 * valueLeafFlags identify the leafs whose value are explicitly set
 * Applicable in protocol edit and query operation.
 * </p>
 */
public class DefaultAddressFamily extends InnerModelObject 
        implements AddressFamily, MultiInstanceObject<AddressFamilyKeys> {
    protected Class<? extends org.onosproject.yang.gen.v1.ietfl3vpnsvc.rev20160730.ietfl3vpnsvc.AddressFamily> af;
    protected long maximumRoutes;
    protected BitSet valueLeafFlags = new BitSet();

    @Override
    public Class<? extends org.onosproject.yang.gen.v1.ietfl3vpnsvc.rev20160730.ietfl3vpnsvc.AddressFamily> af() {
        return af;
    }

    @Override
    public long maximumRoutes() {
        return maximumRoutes;
    }

    @Override
    public BitSet valueLeafFlags() {
        return valueLeafFlags;
    }

    @Override
    public void af(Class<? extends org.onosproject.yang.gen.v1.ietfl3vpnsvc.rev20160730.ietfl3vpnsvc.AddressFamily> af) {
        valueLeafFlags.set(LeafIdentifier.AF.getLeafIndex());
        this.af = af;
    }

    @Override
    public void maximumRoutes(long maximumRoutes) {
        valueLeafFlags.set(LeafIdentifier.MAXIMUMROUTES.getLeafIndex());
        this.maximumRoutes = maximumRoutes;
    }

    @Override
    public int hashCode() {
        return Objects.hash(af, maximumRoutes, valueLeafFlags);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof DefaultAddressFamily) {
            DefaultAddressFamily other = (DefaultAddressFamily) obj;
            return
                Objects.equals(af, other.af) &&
                Objects.equals(maximumRoutes, other.maximumRoutes) &&
                Objects.equals(valueLeafFlags, other.valueLeafFlags);
        }
        return false;
    }

    @Override
    public String toString() {
        return new StringJoiner(", ", getClass().getSimpleName() +"{", "}")
            .add("af=" + af)
            .add("maximumRoutes=" + maximumRoutes)
            .add("valueLeafFlags=" + valueLeafFlags)
            .toString();
    }


    /**
     * Creates an instance of defaultAddressFamily.
     */
    public DefaultAddressFamily() {
    }


    @Override
    public boolean isLeafValueSet(LeafIdentifier leaf) {
        return valueLeafFlags.get(leaf.getLeafIndex());
    }

}