/*
 * Copyright 2017-present Open Networking Laboratory
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.ietfl3vpnsvc.rev20160730.ietfl3vpnsvc.siteserviceqosprofile.qos;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.StringJoiner;
import org.onosproject.yang.gen.v1.ietfl3vpnsvc.rev20160730.ietfl3vpnsvc.siteserviceqosprofile.qos.qosclassificationpolicy.Rule;
import org.onosproject.yang.model.InnerModelObject;

/**
 * Represents the implementation of qosClassificationPolicy.
 *
 * <p>
 * valueLeafFlags identify the leafs whose value are explicitly set
 * Applicable in protocol edit and query operation.
 * </p>
 */
public class DefaultQosClassificationPolicy extends InnerModelObject implements QosClassificationPolicy {
    protected List<Rule> rule;

    @Override
    public List<Rule> rule() {
        return rule;
    }

    @Override
    public void rule(List<Rule> rule) {
        this.rule = rule;
    }

    @Override
    public void addToRule(Rule addTo) {
        if (rule == null) {
            rule = new ArrayList<>();
        }
        rule.add(addTo);
    }


    @Override
    public int hashCode() {
        return Objects.hash(rule);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof DefaultQosClassificationPolicy) {
            DefaultQosClassificationPolicy other = (DefaultQosClassificationPolicy) obj;
            return
                Objects.equals(rule, other.rule);
        }
        return false;
    }

    @Override
    public String toString() {
        return new StringJoiner(", ", getClass().getSimpleName() +"{", "}")
            .add("rule=" + rule)
            .toString();
    }


    /**
     * Creates an instance of defaultQosClassificationPolicy.
     */
    public DefaultQosClassificationPolicy() {
    }

}