/*
 * Copyright 2017-present Open Networking Laboratory
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.ietfl3vpnsvc.rev20160730.ietfl3vpnsvc.sitevpnpolicy.vpnpolicylist;

import java.util.BitSet;
import java.util.List;
import org.onosproject.yang.gen.v1.ietfl3vpnsvc.rev20160730.ietfl3vpnsvc.SvcId;
import org.onosproject.yang.gen.v1.ietfl3vpnsvc.rev20160730.ietfl3vpnsvc.sitevpnpolicy.vpnpolicylist.vpnpolicy.Entries;
import org.onosproject.yang.model.Augmentable;

/**
 * Abstraction of an entity which represents the functionality of vpnPolicy.
 */
public interface VpnPolicy extends Augmentable  {

    /**
     * Identify the leaf of VpnPolicy.
     */
    public enum LeafIdentifier implements org.onosproject.yang.model.LeafIdentifier{
        /**
         * Represents vpnPolicyId.
         */
        VPNPOLICYID(1);

        private int leafIndex;

        public int getLeafIndex() {
            return leafIndex;
        }

        LeafIdentifier(int value) {
            this.leafIndex = value;
        }
    }

    /**
     * Returns the attribute vpnPolicyId.
     *
     * @return vpnPolicyId value of vpnPolicyId
     */
    SvcId vpnPolicyId();

    /**
     * Returns the attribute valueLeafFlags.
     *
     * @return valueLeafFlags value of valueLeafFlags
     */
    BitSet valueLeafFlags();

    /**
     * Returns the attribute entries.
     *
     * @return entries list of entries
     */
    List<Entries> entries();

    /**
     * Sets the attribute vpnPolicyId.
     *
     * @param vpnPolicyId value of vpnPolicyId
     */
    void vpnPolicyId(SvcId vpnPolicyId);

    /**
     * Sets the attribute entries.
     *
     * @param entries list of entries
     */
    void entries(List<Entries> entries);

    /**
     * Adds to the list of entries.
     *
     * @param addTo value of entries
     */
    void addToEntries(Entries addTo);


    /**
     * Checks if the leaf value is set.
     *
     * @param leaf leaf whose value status needs to checked
     * @return result of leaf value set in object
     */
    boolean isLeafValueSet(LeafIdentifier leaf);
}