/*
 * Copyright 2017-present Open Networking Laboratory
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.ietfl3vpnsvc.rev20160730.ietfl3vpnsvc.sitevpnpolicy.vpnpolicylist.vpnpolicy.entries.filter.lan;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import java.util.Objects;
import java.util.StringJoiner;
import org.onosproject.yang.gen.v1.ietfl3vpnsvc.rev20160730.ietfl3vpnsvc.sitevpnpolicy.vpnpolicylist.vpnpolicy.entries.filter.Lan;
import org.onosproject.yang.model.InnerModelObject;

/**
 * Represents the implementation of lanTag.
 *
 * <p>
 * valueLeafFlags identify the leafs whose value are explicitly set
 * Applicable in protocol edit and query operation.
 * </p>
 */
public class DefaultLanTag extends InnerModelObject implements LanTag {
    protected List<String> lanTag;
    protected BitSet valueLeafFlags = new BitSet();

    @Override
    public List<String> lanTag() {
        return lanTag;
    }

    @Override
    public BitSet valueLeafFlags() {
        return valueLeafFlags;
    }

    @Override
    public void lanTag(List<String> lanTag) {
        valueLeafFlags.set(LeafIdentifier.LANTAG.getLeafIndex());
        this.lanTag = lanTag;
    }

    @Override
    public void addToLanTag(String addTo) {
        if (lanTag == null) {
            lanTag = new ArrayList<>();
        }
        lanTag.add(addTo);
    }


    @Override
    public int hashCode() {
        return Objects.hash(lanTag, valueLeafFlags);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof DefaultLanTag) {
            DefaultLanTag other = (DefaultLanTag) obj;
            return
                Objects.equals(lanTag, other.lanTag) &&
                Objects.equals(valueLeafFlags, other.valueLeafFlags);
        }
        return false;
    }

    @Override
    public String toString() {
        return new StringJoiner(", ", getClass().getSimpleName() +"{", "}")
            .add("lanTag=" + lanTag)
            .add("valueLeafFlags=" + valueLeafFlags)
            .toString();
    }


    /**
     * Creates an instance of defaultLanTag.
     */
    public DefaultLanTag() {
    }


    @Override
    public boolean isLeafValueSet(LeafIdentifier leaf) {
        return valueLeafFlags.get(leaf.getLeafIndex());
    }

}