/*
 * Copyright 2017-present Open Networking Laboratory
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.ietfl3vpnsvc.rev20160730.ietfl3vpnsvc.transportconstraintprofile;

import java.util.BitSet;
import org.onosproject.yang.gen.v1.ietfl3vpnsvc.rev20160730.ietfl3vpnsvc.TransportConstraint;
import org.onosproject.yang.model.Augmentable;

/**
 * Abstraction of an entity which represents the functionality of constraintList.
 */
public interface ConstraintList extends Augmentable  {

    /**
     * Identify the leaf of ConstraintList.
     */
    public enum LeafIdentifier implements org.onosproject.yang.model.LeafIdentifier{
        /**
         * Represents constraintType.
         */
        CONSTRAINTTYPE(1),
        /**
         * Represents constraintOpaqueValue.
         */
        CONSTRAINTOPAQUEVALUE(2);

        private int leafIndex;

        public int getLeafIndex() {
            return leafIndex;
        }

        LeafIdentifier(int value) {
            this.leafIndex = value;
        }
    }

    /**
     * Returns the attribute constraintType.
     *
     * @return constraintType value of constraintType
     */
    Class<? extends TransportConstraint> constraintType();

    /**
     * Returns the attribute constraintOpaqueValue.
     *
     * @return constraintOpaqueValue value of constraintOpaqueValue
     */
    String constraintOpaqueValue();

    /**
     * Returns the attribute valueLeafFlags.
     *
     * @return valueLeafFlags value of valueLeafFlags
     */
    BitSet valueLeafFlags();

    /**
     * Sets the attribute constraintType.
     *
     * @param constraintType value of constraintType
     */
    void constraintType(Class<? extends TransportConstraint> constraintType);

    /**
     * Sets the attribute constraintOpaqueValue.
     *
     * @param constraintOpaqueValue value of constraintOpaqueValue
     */
    void constraintOpaqueValue(String constraintOpaqueValue);


    /**
     * Checks if the leaf value is set.
     *
     * @param leaf leaf whose value status needs to checked
     * @return result of leaf value set in object
     */
    boolean isLeafValueSet(LeafIdentifier leaf);
}