/*
 * Copyright 2017-present Open Networking Laboratory
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.ietfl3vpnsvc.rev20160730.ietfl3vpnsvc.transportconstraints.transportconstraints.multicasttransportconstraints;

import java.util.BitSet;
import java.util.List;
import org.onosproject.yang.gen.v1.ietfl3vpnsvc.rev20160730.ietfl3vpnsvc.SvcId;
import org.onosproject.yang.gen.v1.ietfl3vpnsvc.rev20160730.ietfl3vpnsvc.transportconstraintprofile.ConstraintList;
import org.onosproject.yang.model.Augmentable;

/**
 * Abstraction of an entity which represents the functionality of constraint.
 */
public interface Constraint extends Augmentable  {

    /**
     * Identify the leaf of Constraint.
     */
    public enum LeafIdentifier implements org.onosproject.yang.model.LeafIdentifier{
        /**
         * Represents constraintId.
         */
        CONSTRAINTID(1),
        /**
         * Represents srcSite.
         */
        SRCSITE(2),
        /**
         * Represents dstSite.
         */
        DSTSITE(3);

        private int leafIndex;

        public int getLeafIndex() {
            return leafIndex;
        }

        LeafIdentifier(int value) {
            this.leafIndex = value;
        }
    }

    /**
     * Returns the attribute constraintId.
     *
     * @return constraintId value of constraintId
     */
    SvcId constraintId();

    /**
     * Returns the attribute srcSite.
     *
     * @return srcSite value of srcSite
     */
    SvcId srcSite();

    /**
     * Returns the attribute dstSite.
     *
     * @return dstSite value of dstSite
     */
    SvcId dstSite();

    /**
     * Returns the attribute valueLeafFlags.
     *
     * @return valueLeafFlags value of valueLeafFlags
     */
    BitSet valueLeafFlags();

    /**
     * Returns the attribute constraintList.
     *
     * @return constraintList list of constraintList
     */
    List<ConstraintList> constraintList();

    /**
     * Sets the attribute constraintId.
     *
     * @param constraintId value of constraintId
     */
    void constraintId(SvcId constraintId);

    /**
     * Sets the attribute srcSite.
     *
     * @param srcSite value of srcSite
     */
    void srcSite(SvcId srcSite);

    /**
     * Sets the attribute dstSite.
     *
     * @param dstSite value of dstSite
     */
    void dstSite(SvcId dstSite);

    /**
     * Sets the attribute constraintList.
     *
     * @param constraintList list of constraintList
     */
    void constraintList(List<ConstraintList> constraintList);

    /**
     * Adds to the list of constraintList.
     *
     * @param addTo value of constraintList
     */
    void addToConstraintList(ConstraintList addTo);


    /**
     * Checks if the leaf value is set.
     *
     * @param leaf leaf whose value status needs to checked
     * @return result of leaf value set in object
     */
    boolean isLeafValueSet(LeafIdentifier leaf);
}