/*
 * Copyright 2017-present Open Networking Laboratory
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.ietfl3vpnsvc.rev20160730.ietfl3vpnsvc.vpnextranet;

import java.util.List;
import org.onosproject.yang.gen.v1.ietfl3vpnsvc.rev20160730.ietfl3vpnsvc.vpnextranet.extranetvpns.ExtranetVpn;
import org.onosproject.yang.model.Augmentable;

/**
 * Abstraction of an entity which represents the functionality of extranetVpns.
 */
public interface ExtranetVpns extends Augmentable  {

    /**
     * Returns the attribute extranetVpn.
     *
     * @return extranetVpn list of extranetVpn
     */
    List<ExtranetVpn> extranetVpn();

    /**
     * Sets the attribute extranetVpn.
     *
     * @param extranetVpn list of extranetVpn
     */
    void extranetVpn(List<ExtranetVpn> extranetVpn);

    /**
     * Adds to the list of extranetVpn.
     *
     * @param addTo value of extranetVpn
     */
    void addToExtranetVpn(ExtranetVpn addTo);

}