/*
 * Copyright 2017-present Open Networking Laboratory
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.ietfl3vpnsvc.rev20160730.ietfl3vpnsvc.vpnextranet.extranetvpns;

import java.util.BitSet;
import java.util.Objects;
import java.util.StringJoiner;
import org.onosproject.yang.gen.v1.ietfl3vpnsvc.rev20160730.ietfl3vpnsvc.SiteRole;
import org.onosproject.yang.gen.v1.ietfl3vpnsvc.rev20160730.ietfl3vpnsvc.SvcId;
import org.onosproject.yang.model.InnerModelObject;
import org.onosproject.yang.model.MultiInstanceObject;

/**
 * Represents the implementation of extranetVpn.
 *
 * <p>
 * valueLeafFlags identify the leafs whose value are explicitly set
 * Applicable in protocol edit and query operation.
 * </p>
 */
public class DefaultExtranetVpn extends InnerModelObject 
        implements ExtranetVpn, MultiInstanceObject<ExtranetVpnKeys> {
    protected SvcId vpnId;
    protected Class<? extends SiteRole> localSitesRole;
    protected BitSet valueLeafFlags = new BitSet();

    @Override
    public SvcId vpnId() {
        return vpnId;
    }

    @Override
    public Class<? extends SiteRole> localSitesRole() {
        return localSitesRole;
    }

    @Override
    public BitSet valueLeafFlags() {
        return valueLeafFlags;
    }

    @Override
    public void vpnId(SvcId vpnId) {
        valueLeafFlags.set(LeafIdentifier.VPNID.getLeafIndex());
        this.vpnId = vpnId;
    }

    @Override
    public void localSitesRole(Class<? extends SiteRole> localSitesRole) {
        valueLeafFlags.set(LeafIdentifier.LOCALSITESROLE.getLeafIndex());
        this.localSitesRole = localSitesRole;
    }

    @Override
    public int hashCode() {
        return Objects.hash(vpnId, localSitesRole, valueLeafFlags);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof DefaultExtranetVpn) {
            DefaultExtranetVpn other = (DefaultExtranetVpn) obj;
            return
                Objects.equals(vpnId, other.vpnId) &&
                Objects.equals(localSitesRole, other.localSitesRole) &&
                Objects.equals(valueLeafFlags, other.valueLeafFlags);
        }
        return false;
    }

    @Override
    public String toString() {
        return new StringJoiner(", ", getClass().getSimpleName() +"{", "}")
            .add("vpnId=" + vpnId)
            .add("localSitesRole=" + localSitesRole)
            .add("valueLeafFlags=" + valueLeafFlags)
            .toString();
    }


    /**
     * Creates an instance of defaultExtranetVpn.
     */
    public DefaultExtranetVpn() {
    }


    @Override
    public boolean isLeafValueSet(LeafIdentifier leaf) {
        return valueLeafFlags.get(leaf.getLeafIndex());
    }

}