/*
 * Copyright 2017-present Open Networking Laboratory
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.ietfl3vpnsvc.rev20160730.ietfl3vpnsvc.vpnservicemulticast.multicast.rp.rpdiscovery.bsrcandidates;

import org.onosproject.yang.gen.v1.yrtietfinettypes.rev20130715.yrtietfinettypes.IpAddress;
import org.onosproject.yang.model.KeyInfo;
import java.util.Objects;

/**
 * Represents the implementation of bsrCandidate.
 */
public class BsrCandidateKeys implements KeyInfo<DefaultBsrCandidate> {
    protected IpAddress address;
    /**
     * Returns the attribute address.
     *
     * @return address value of address
     */
    public IpAddress address() {
        return address;
    }

    /**
     * Sets the value to attribute address.
     *
     * @param address value of address
     */
    public void address(IpAddress address) {
        this.address = address;
    }


    @Override
    public int hashCode() {
        return Objects.hash(address);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof BsrCandidateKeys) {
            BsrCandidateKeys other = (BsrCandidateKeys) obj;
            return
                Objects.equals(address, other.address);
        }
        return false;
    }
}