/*
 * Copyright 2017-present Open Networking Laboratory
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.ietfl3vpnsvc.rev20160730.ietfl3vpnsvc.vpnservicemulticast.multicast.rp.rpgroupmappings.rpgroupmapping.groups;

import java.util.BitSet;
import java.util.Objects;
import java.util.StringJoiner;
import org.onosproject.yang.gen.v1.ietfl3vpnsvc.rev20160730.ietfl3vpnsvc.multicastrpgroupcfg.GroupFormat;
import org.onosproject.yang.model.InnerModelObject;
import org.onosproject.yang.model.MultiInstanceObject;

/**
 * Represents the implementation of group.
 *
 * <p>
 * valueLeafFlags identify the leafs whose value are explicitly set
 * Applicable in protocol edit and query operation.
 * </p>
 */
public class DefaultGroup extends InnerModelObject 
        implements Group, MultiInstanceObject<GroupKeys> {
    protected int id;
    protected BitSet valueLeafFlags = new BitSet();
    protected GroupFormat groupFormat;

    @Override
    public int id() {
        return id;
    }

    @Override
    public BitSet valueLeafFlags() {
        return valueLeafFlags;
    }

    @Override
    public GroupFormat groupFormat() {
        return groupFormat;
    }

    @Override
    public void id(int id) {
        valueLeafFlags.set(LeafIdentifier.ID.getLeafIndex());
        this.id = id;
    }

    @Override
    public void groupFormat(GroupFormat groupFormat) {
        this.groupFormat = groupFormat;
    }

    @Override
    public int hashCode() {
        return Objects.hash(id, valueLeafFlags, groupFormat);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof DefaultGroup) {
            DefaultGroup other = (DefaultGroup) obj;
            return
                Objects.equals(id, other.id) &&
                Objects.equals(valueLeafFlags, other.valueLeafFlags) &&
                Objects.equals(groupFormat, other.groupFormat);
        }
        return false;
    }

    @Override
    public String toString() {
        return new StringJoiner(", ", getClass().getSimpleName() +"{", "}")
            .add("id=" + id)
            .add("valueLeafFlags=" + valueLeafFlags)
            .add("groupFormat=" + groupFormat)
            .toString();
    }


    /**
     * Creates an instance of defaultGroup.
     */
    public DefaultGroup() {
    }


    @Override
    public boolean isLeafValueSet(LeafIdentifier leaf) {
        return valueLeafFlags.get(leaf.getLeafIndex());
    }

}