/*
 * Copyright 2017-present Open Networking Laboratory
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.l3vpnsvcext.rev20160730.l3vpnsvcext;

import org.onosproject.yang.gen.v1.yrtietfinettypes.rev20130715.yrtietfinettypes.AsNumber;
import java.util.Objects;

/**
 * Represents the implementation of shortAsNumber.
 */
public final class ShortAsNumber {

    private AsNumber asNumber;

    /**
     * Creates an instance of shortAsNumber.
     */
    private ShortAsNumber() {
    }

    /**
     * Creates an instance of asNumber.
     *
     * @param asNumber value of asNumber
     */
    public ShortAsNumber(AsNumber asNumber) {
        this.asNumber = asNumber;
    }

    /**
     * Returns the object of shortAsNumber for type asNumber.
     *
     * @param value value of shortAsNumber for type asNumber
     * @return shortAsNumber for type asNumber
     */
    public static ShortAsNumber of(AsNumber value) {
        return new ShortAsNumber(value);
    }

    /**
     * Returns the attribute asNumber.
     *
     * @return asNumber value of asNumber
     */
    public AsNumber asNumber() {
        return asNumber;
    }
    /**
     * Sets the attribute asNumber.
     *
     * @param asNumber value of asNumber
     */
    public void asNumber(AsNumber asNumber) {
        this.asNumber = asNumber;
    }

    @Override
    public int hashCode() {
        return Objects.hash(asNumber);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof ShortAsNumber) {
            ShortAsNumber other = (ShortAsNumber) obj;
            return
                Objects.equals(asNumber, other.asNumber);
        }
        return false;
    }

    @Override
    public String toString() {
        return asNumber.toString();
    }
    /**
     * Returns the object of shortAsNumber fromString input String shortAsNumber.
     *
     * @param valInString value of input String
     * @return shortAsNumber
     */
    public static ShortAsNumber fromString(String valInString) {
        try {
            AsNumber tmpVal = AsNumber.fromString(valInString);
            return of(tmpVal);
        } catch (Exception e) {
            throw new IllegalArgumentException("not a valid input element");
        }
    }
}
