/*
 * Copyright 2017-present Open Networking Laboratory
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.l3vpnsvcext.rev20160730.l3vpnsvcext.l3vpnsvc.sites.site.sitenetworkaccesses.sitenetworkaccess.bearer.requestedtype;

import java.util.Objects;
import java.util.StringJoiner;
import org.onosproject.yang.gen.v1.l3vpnsvcext.rev20160730.l3vpnsvcext.requestedtypegrouping.RequestedTypeProfile;
import org.onosproject.yang.model.InnerModelObject;

/**
 * Represents the implementation of augmentedL3VpnRequestedType.
 *
 * <p>
 * valueLeafFlags identify the leafs whose value are explicitly set
 * Applicable in protocol edit and query operation.
 * </p>
 */
public class DefaultAugmentedL3VpnRequestedType extends InnerModelObject implements AugmentedL3VpnRequestedType {
    protected RequestedTypeProfile requestedTypeProfile;

    @Override
    public RequestedTypeProfile requestedTypeProfile() {
        return requestedTypeProfile;
    }

    @Override
    public void requestedTypeProfile(RequestedTypeProfile requestedTypeProfile) {
        this.requestedTypeProfile = requestedTypeProfile;
    }

    @Override
    public int hashCode() {
        return Objects.hash(requestedTypeProfile);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof DefaultAugmentedL3VpnRequestedType) {
            DefaultAugmentedL3VpnRequestedType other = (DefaultAugmentedL3VpnRequestedType) obj;
            return
                Objects.equals(requestedTypeProfile, other.requestedTypeProfile);
        }
        return false;
    }

    @Override
    public String toString() {
        return new StringJoiner(", ", getClass().getSimpleName() +"{", "}")
            .add("requestedTypeProfile=" + requestedTypeProfile)
            .toString();
    }


    /**
     * Creates an instance of defaultAugmentedL3VpnRequestedType.
     */
    public DefaultAugmentedL3VpnRequestedType() {
    }

}