/*
 * Copyright 2017-present Open Networking Laboratory
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.l3vpnsvcext.rev20160730.l3vpnsvcext.l3vpnsvc.sites.site.sitenetworkaccesses.sitenetworkaccess.routingprotocols.routingprotocol.bgp;

import java.util.BitSet;
import org.onosproject.yang.gen.v1.l3vpnsvcext.rev20160730.l3vpnsvcext.bgpprofile.Bfd;
import org.onosproject.yang.gen.v1.l3vpnsvcext.rev20160730.l3vpnsvcext.bgpprofile.BgpTimer;
import org.onosproject.yang.gen.v1.l3vpnsvcext.rev20160730.l3vpnsvcext.bgpprofile.Password;
import org.onosproject.yang.gen.v1.l3vpnsvcext.rev20160730.l3vpnsvcext.bgpprofile.Soo;

/**
 * Abstraction of an entity which represents the functionality of augmentedL3VpnBgp.
 */
public interface AugmentedL3VpnBgp {

    /**
     * Identify the leaf of AugmentedL3VpnBgp.
     */
    public enum LeafIdentifier implements org.onosproject.yang.model.LeafIdentifier{
        /**
         * Represents asOverride.
         */
        ASOVERRIDE(1);

        private int leafIndex;

        public int getLeafIndex() {
            return leafIndex;
        }

        LeafIdentifier(int value) {
            this.leafIndex = value;
        }
    }

    /**
     * Returns the attribute asOverride.
     *
     * @return asOverride value of asOverride
     */
    boolean asOverride();

    /**
     * Returns the attribute valueLeafFlags.
     *
     * @return valueLeafFlags value of valueLeafFlags
     */
    BitSet valueLeafFlags();

    /**
     * Returns the attribute soo.
     *
     * @return soo value of soo
     */
    Soo soo();

    /**
     * Returns the attribute password.
     *
     * @return password value of password
     */
    Password password();

    /**
     * Returns the attribute bgpTimer.
     *
     * @return bgpTimer value of bgpTimer
     */
    BgpTimer bgpTimer();

    /**
     * Returns the attribute bfd.
     *
     * @return bfd value of bfd
     */
    Bfd bfd();

    /**
     * Sets the attribute asOverride.
     *
     * @param asOverride value of asOverride
     */
    void asOverride(boolean asOverride);

    /**
     * Sets the attribute soo.
     *
     * @param soo value of soo
     */
    void soo(Soo soo);

    /**
     * Sets the attribute password.
     *
     * @param password value of password
     */
    void password(Password password);

    /**
     * Sets the attribute bgpTimer.
     *
     * @param bgpTimer value of bgpTimer
     */
    void bgpTimer(BgpTimer bgpTimer);

    /**
     * Sets the attribute bfd.
     *
     * @param bfd value of bfd
     */
    void bfd(Bfd bfd);


    /**
     * Checks if the leaf value is set.
     *
     * @param leaf leaf whose value status needs to checked
     * @return result of leaf value set in object
     */
    boolean isLeafValueSet(LeafIdentifier leaf);
}