/*
 * Copyright 2017-present Open Networking Laboratory
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.l3vpnsvcext.rev20160730.l3vpnsvcext.rdrtprofile.siterole.customcase.custom;

import java.util.BitSet;
import java.util.Objects;
import java.util.StringJoiner;
import org.onosproject.yang.gen.v1.l3vpnsvcext.rev20160730.l3vpnsvcext.extendedcommunity.ExtendedCommunity;
import org.onosproject.yang.model.InnerModelObject;
import org.onosproject.yang.model.MultiInstanceObject;

/**
 * Represents the implementation of importRt.
 *
 * <p>
 * valueLeafFlags identify the leafs whose value are explicitly set
 * Applicable in protocol edit and query operation.
 * </p>
 */
public class DefaultImportRt extends InnerModelObject 
        implements ImportRt, MultiInstanceObject<ImportRtKeys> {
    protected String imrtId;
    protected BitSet valueLeafFlags = new BitSet();
    protected ExtendedCommunity extendedCommunity;

    @Override
    public String imrtId() {
        return imrtId;
    }

    @Override
    public BitSet valueLeafFlags() {
        return valueLeafFlags;
    }

    @Override
    public ExtendedCommunity extendedCommunity() {
        return extendedCommunity;
    }

    @Override
    public void imrtId(String imrtId) {
        valueLeafFlags.set(LeafIdentifier.IMRTID.getLeafIndex());
        this.imrtId = imrtId;
    }

    @Override
    public void extendedCommunity(ExtendedCommunity extendedCommunity) {
        this.extendedCommunity = extendedCommunity;
    }

    @Override
    public int hashCode() {
        return Objects.hash(imrtId, valueLeafFlags, extendedCommunity);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof DefaultImportRt) {
            DefaultImportRt other = (DefaultImportRt) obj;
            return
                Objects.equals(imrtId, other.imrtId) &&
                Objects.equals(valueLeafFlags, other.valueLeafFlags) &&
                Objects.equals(extendedCommunity, other.extendedCommunity);
        }
        return false;
    }

    @Override
    public String toString() {
        return new StringJoiner(", ", getClass().getSimpleName() +"{", "}")
            .add("imrtId=" + imrtId)
            .add("valueLeafFlags=" + valueLeafFlags)
            .add("extendedCommunity=" + extendedCommunity)
            .toString();
    }


    /**
     * Creates an instance of defaultImportRt.
     */
    public DefaultImportRt() {
    }


    @Override
    public boolean isLeafValueSet(LeafIdentifier leaf) {
        return valueLeafFlags.get(leaf.getLeafIndex());
    }

}