/*
 * Copyright 2017-present Open Networking Laboratory
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.modeldatatoresourcedata.rev20160826.modeldatatoresourcedata.firstlevel;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.StringJoiner;
import org.onosproject.yang.gen.v1.modeldatatoresourcedata.rev20160826.modeldatatoresourcedata.firstlevel.containerlist.ListLeaf;
import org.onosproject.yang.model.InnerModelObject;

/**
 * Represents the implementation of containerList.
 *
 * <p>
 * valueLeafFlags identify the leafs whose value are explicitly set
 * Applicable in protocol edit and query operation.
 * </p>
 */
public class DefaultContainerList extends InnerModelObject implements ContainerList {
    protected List<ListLeaf> listLeaf;

    @Override
    public List<ListLeaf> listLeaf() {
        return listLeaf;
    }

    @Override
    public void listLeaf(List<ListLeaf> listLeaf) {
        this.listLeaf = listLeaf;
    }

    @Override
    public void addToListLeaf(ListLeaf addTo) {
        if (listLeaf == null) {
            listLeaf = new ArrayList<>();
        }
        listLeaf.add(addTo);
    }


    @Override
    public int hashCode() {
        return Objects.hash(listLeaf);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof DefaultContainerList) {
            DefaultContainerList other = (DefaultContainerList) obj;
            return
                Objects.equals(listLeaf, other.listLeaf);
        }
        return false;
    }

    @Override
    public String toString() {
        return new StringJoiner(", ", getClass().getSimpleName() +"{", "}")
            .add("listLeaf=" + listLeaf)
            .toString();
    }


    /**
     * Creates an instance of defaultContainerList.
     */
    public DefaultContainerList() {
    }

}