/*
 * Copyright 2017-present Open Networking Laboratory
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.modeldatatoresourcedatainterfile.rev20160826.modeldatatoresourcedatainterfile.firstlevel;

import java.util.Objects;
import java.util.StringJoiner;
import org.onosproject.yang.gen.v1.modeldatatoresourcedatainterfile.rev20160826.modeldatatoresourcedatainterfile.firstlevel.augmentedschfirstlevel.InterContainer;
import org.onosproject.yang.model.InnerModelObject;

/**
 * Represents the implementation of augmentedSchFirstLevel.
 *
 * <p>
 * valueLeafFlags identify the leafs whose value are explicitly set
 * Applicable in protocol edit and query operation.
 * </p>
 */
public class DefaultAugmentedSchFirstLevel extends InnerModelObject implements AugmentedSchFirstLevel {
    protected InterContainer interContainer;

    @Override
    public InterContainer interContainer() {
        return interContainer;
    }

    @Override
    public void interContainer(InterContainer interContainer) {
        this.interContainer = interContainer;
    }

    @Override
    public int hashCode() {
        return Objects.hash(interContainer);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof DefaultAugmentedSchFirstLevel) {
            DefaultAugmentedSchFirstLevel other = (DefaultAugmentedSchFirstLevel) obj;
            return
                Objects.equals(interContainer, other.interContainer);
        }
        return false;
    }

    @Override
    public String toString() {
        return new StringJoiner(", ", getClass().getSimpleName() +"{", "}")
            .add("interContainer=" + interContainer)
            .toString();
    }


    /**
     * Creates an instance of defaultAugmentedSchFirstLevel.
     */
    public DefaultAugmentedSchFirstLevel() {
    }

}