/*
 * Copyright 2017-present Open Networking Laboratory
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.modulelistandkey.rev20160826;

import java.util.List;
import org.onosproject.yang.gen.v1.modulelistandkey.rev20160826.modulelistandkey.ModKey;

/**
 * Abstraction of an entity which represents the functionality of moduleListAndKey.
 */
public interface ModuleListAndKey {

    /**
     * Returns the attribute modKey.
     *
     * @return modKey list of modKey
     */
    List<ModKey> modKey();

    /**
     * Sets the attribute modKey.
     *
     * @param modKey list of modKey
     */
    void modKey(List<ModKey> modKey);

    /**
     * Adds to the list of modKey.
     *
     * @param addTo value of modKey
     */
    void addToModKey(ModKey addTo);

}