/*
 * Copyright 2017-present Open Networking Laboratory
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.simpledatatypes.rev20131112.simpledatatypes;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.BitSet;
import org.onosproject.yang.gen.v1.simpledatatypes.rev20131112.simpledatatypes.cont.LfenumEnum;
import org.onosproject.yang.gen.v1.simpledatatypes.rev20131112.simpledatatypes.cont.Lfunion10Union;
import org.onosproject.yang.gen.v1.simpledatatypes.rev20131112.simpledatatypes.cont.Lfunion11Union;
import org.onosproject.yang.gen.v1.simpledatatypes.rev20131112.simpledatatypes.cont.Lfunion14Union;
import org.onosproject.yang.gen.v1.simpledatatypes.rev20131112.simpledatatypes.cont.Lfunion1Union;
import org.onosproject.yang.gen.v1.simpledatatypes.rev20131112.simpledatatypes.cont.Lfunion2Union;
import org.onosproject.yang.gen.v1.simpledatatypes.rev20131112.simpledatatypes.cont.Lfunion4Union;
import org.onosproject.yang.gen.v1.simpledatatypes.rev20131112.simpledatatypes.cont.Lfunion5Union;
import org.onosproject.yang.gen.v1.simpledatatypes.rev20131112.simpledatatypes.cont.Lfunion8Union;
import org.onosproject.yang.gen.v1.simpledatatypes.rev20131112.simpledatatypes.cont.Lfunion9Union;
import org.onosproject.yang.model.Augmentable;

/**
 * Abstraction of an entity which represents the functionality of cont.
 */
public interface Cont extends Augmentable  {

    /**
     * Identify the leaf of Cont.
     */
    public enum LeafIdentifier implements org.onosproject.yang.model.LeafIdentifier{
        /**
         * Represents lfnint8Min.
         */
        LFNINT8MIN(1),
        /**
         * Represents lfnint8Max.
         */
        LFNINT8MAX(2),
        /**
         * Represents lfnint16Min.
         */
        LFNINT16MIN(3),
        /**
         * Represents lfnint16Max.
         */
        LFNINT16MAX(4),
        /**
         * Represents lfnint32Min.
         */
        LFNINT32MIN(5),
        /**
         * Represents lfnint32Max.
         */
        LFNINT32MAX(6),
        /**
         * Represents lfnint64Min.
         */
        LFNINT64MIN(7),
        /**
         * Represents lfnint64Max.
         */
        LFNINT64MAX(8),
        /**
         * Represents lfnuint8Max.
         */
        LFNUINT8MAX(9),
        /**
         * Represents lfnuint16Max.
         */
        LFNUINT16MAX(10),
        /**
         * Represents lfnuint32Max.
         */
        LFNUINT32MAX(11),
        /**
         * Represents lfuint64Max.
         */
        LFUINT64MAX(12),
        /**
         * Represents lfstr.
         */
        LFSTR(13),
        /**
         * Represents lfstr1.
         */
        LFSTR1(14),
        /**
         * Represents lfbool1.
         */
        LFBOOL1(15),
        /**
         * Represents lfbool2.
         */
        LFBOOL2(16),
        /**
         * Represents lfbool3.
         */
        LFBOOL3(17),
        /**
         * Represents lfdecimal1.
         */
        LFDECIMAL1(18),
        /**
         * Represents lfdecimal2.
         */
        LFDECIMAL2(19),
        /**
         * Represents lfdecimal3.
         */
        LFDECIMAL3(20),
        /**
         * Represents lfdecimal4.
         */
        LFDECIMAL4(21),
        /**
         * Represents lfdecimal6.
         */
        LFDECIMAL6(22),
        /**
         * Represents lfenum.
         */
        LFENUM(23),
        /**
         * Represents lfbits.
         */
        LFBITS(24),
        /**
         * Represents lfbinary.
         */
        LFBINARY(25),
        /**
         * Represents lfref1.
         */
        LFREF1(26),
        /**
         * Represents lfref2.
         */
        LFREF2(27),
        /**
         * Represents lfempty.
         */
        LFEMPTY(28),
        /**
         * Represents lfunion1.
         */
        LFUNION1(29),
        /**
         * Represents lfunion2.
         */
        LFUNION2(30),
        /**
         * Represents lfunion4.
         */
        LFUNION4(31),
        /**
         * Represents lfunion5.
         */
        LFUNION5(32),
        /**
         * Represents lfunion7.
         */
        LFUNION7(33),
        /**
         * Represents lfunion8.
         */
        LFUNION8(34),
        /**
         * Represents lfunion9.
         */
        LFUNION9(35),
        /**
         * Represents lfunion10.
         */
        LFUNION10(36),
        /**
         * Represents lfunion11.
         */
        LFUNION11(37),
        /**
         * Represents lfunion12.
         */
        LFUNION12(38),
        /**
         * Represents lfunion13.
         */
        LFUNION13(39),
        /**
         * Represents lfunion14.
         */
        LFUNION14(40),
        /**
         * Represents identityref1.
         */
        IDENTITYREF1(41),
        /**
         * Represents lfenum1.
         */
        LFENUM1(42);

        private int leafIndex;

        public int getLeafIndex() {
            return leafIndex;
        }

        LeafIdentifier(int value) {
            this.leafIndex = value;
        }
    }

    /**
     * Returns the attribute lfnint8Min.
     *
     * @return lfnint8Min value of lfnint8Min
     */
    byte lfnint8Min();

    /**
     * Returns the attribute lfnint8Max.
     *
     * @return lfnint8Max value of lfnint8Max
     */
    byte lfnint8Max();

    /**
     * Returns the attribute lfnint16Min.
     *
     * @return lfnint16Min value of lfnint16Min
     */
    short lfnint16Min();

    /**
     * Returns the attribute lfnint16Max.
     *
     * @return lfnint16Max value of lfnint16Max
     */
    short lfnint16Max();

    /**
     * Returns the attribute lfnint32Min.
     *
     * @return lfnint32Min value of lfnint32Min
     */
    int lfnint32Min();

    /**
     * Returns the attribute lfnint32Max.
     *
     * @return lfnint32Max value of lfnint32Max
     */
    int lfnint32Max();

    /**
     * Returns the attribute lfnint64Min.
     *
     * @return lfnint64Min value of lfnint64Min
     */
    long lfnint64Min();

    /**
     * Returns the attribute lfnint64Max.
     *
     * @return lfnint64Max value of lfnint64Max
     */
    long lfnint64Max();

    /**
     * Returns the attribute lfnuint8Max.
     *
     * @return lfnuint8Max value of lfnuint8Max
     */
    short lfnuint8Max();

    /**
     * Returns the attribute lfnuint16Max.
     *
     * @return lfnuint16Max value of lfnuint16Max
     */
    int lfnuint16Max();

    /**
     * Returns the attribute lfnuint32Max.
     *
     * @return lfnuint32Max value of lfnuint32Max
     */
    long lfnuint32Max();

    /**
     * Returns the attribute lfuint64Max.
     *
     * @return lfuint64Max value of lfuint64Max
     */
    BigInteger lfuint64Max();

    /**
     * Returns the attribute lfstr.
     *
     * @return lfstr value of lfstr
     */
    String lfstr();

    /**
     * Returns the attribute lfstr1.
     *
     * @return lfstr1 value of lfstr1
     */
    String lfstr1();

    /**
     * Returns the attribute lfbool1.
     *
     * @return lfbool1 value of lfbool1
     */
    boolean lfbool1();

    /**
     * Returns the attribute lfbool2.
     *
     * @return lfbool2 value of lfbool2
     */
    boolean lfbool2();

    /**
     * Returns the attribute lfbool3.
     *
     * @return lfbool3 value of lfbool3
     */
    boolean lfbool3();

    /**
     * Returns the attribute lfdecimal1.
     *
     * @return lfdecimal1 value of lfdecimal1
     */
    BigDecimal lfdecimal1();

    /**
     * Returns the attribute lfdecimal2.
     *
     * @return lfdecimal2 value of lfdecimal2
     */
    BigDecimal lfdecimal2();

    /**
     * Returns the attribute lfdecimal3.
     *
     * @return lfdecimal3 value of lfdecimal3
     */
    BigDecimal lfdecimal3();

    /**
     * Returns the attribute lfdecimal4.
     *
     * @return lfdecimal4 value of lfdecimal4
     */
    BigDecimal lfdecimal4();

    /**
     * Returns the attribute lfdecimal6.
     *
     * @return lfdecimal6 value of lfdecimal6
     */
    BigDecimal lfdecimal6();

    /**
     * Returns the attribute lfenum.
     *
     * @return lfenum value of lfenum
     */
    LfenumEnum lfenum();

    /**
     * Returns the attribute lfbits.
     *
     * @return lfbits value of lfbits
     */
    BitSet lfbits();

    /**
     * Returns the attribute lfbinary.
     *
     * @return lfbinary value of lfbinary
     */
    byte[] lfbinary();

    /**
     * Returns the attribute lfref1.
     *
     * @return lfref1 value of lfref1
     */
    String lfref1();

    /**
     * Returns the attribute lfref2.
     *
     * @return lfref2 value of lfref2
     */
    byte lfref2();

    /**
     * Returns the attribute lfempty.
     *
     * @return lfempty value of lfempty
     */
    boolean lfempty();

    /**
     * Returns the attribute lfunion1.
     *
     * @return lfunion1 value of lfunion1
     */
    Lfunion1Union lfunion1();

    /**
     * Returns the attribute lfunion2.
     *
     * @return lfunion2 value of lfunion2
     */
    Lfunion2Union lfunion2();

    /**
     * Returns the attribute lfunion4.
     *
     * @return lfunion4 value of lfunion4
     */
    Lfunion4Union lfunion4();

    /**
     * Returns the attribute lfunion5.
     *
     * @return lfunion5 value of lfunion5
     */
    Lfunion5Union lfunion5();

    /**
     * Returns the attribute lfunion7.
     *
     * @return lfunion7 value of lfunion7
     */
    Tpdfun3 lfunion7();

    /**
     * Returns the attribute lfunion8.
     *
     * @return lfunion8 value of lfunion8
     */
    Lfunion8Union lfunion8();

    /**
     * Returns the attribute lfunion9.
     *
     * @return lfunion9 value of lfunion9
     */
    Lfunion9Union lfunion9();

    /**
     * Returns the attribute lfunion10.
     *
     * @return lfunion10 value of lfunion10
     */
    Lfunion10Union lfunion10();

    /**
     * Returns the attribute lfunion11.
     *
     * @return lfunion11 value of lfunion11
     */
    Lfunion11Union lfunion11();

    /**
     * Returns the attribute lfunion12.
     *
     * @return lfunion12 value of lfunion12
     */
    Tpdfun2 lfunion12();

    /**
     * Returns the attribute lfunion13.
     *
     * @return lfunion13 value of lfunion13
     */
    Tpdfbit lfunion13();

    /**
     * Returns the attribute lfunion14.
     *
     * @return lfunion14 value of lfunion14
     */
    Lfunion14Union lfunion14();

    /**
     * Returns the attribute identityref1.
     *
     * @return identityref1 value of identityref1
     */
    Class<? extends Iden> identityref1();

    /**
     * Returns the attribute lfenum1.
     *
     * @return lfenum1 value of lfenum1
     */
    Tpdfun0 lfenum1();

    /**
     * Returns the attribute valueLeafFlags.
     *
     * @return valueLeafFlags value of valueLeafFlags
     */
    BitSet valueLeafFlags();

    /**
     * Sets the attribute lfnint8Min.
     *
     * @param lfnint8Min value of lfnint8Min
     */
    void lfnint8Min(byte lfnint8Min);

    /**
     * Sets the attribute lfnint8Max.
     *
     * @param lfnint8Max value of lfnint8Max
     */
    void lfnint8Max(byte lfnint8Max);

    /**
     * Sets the attribute lfnint16Min.
     *
     * @param lfnint16Min value of lfnint16Min
     */
    void lfnint16Min(short lfnint16Min);

    /**
     * Sets the attribute lfnint16Max.
     *
     * @param lfnint16Max value of lfnint16Max
     */
    void lfnint16Max(short lfnint16Max);

    /**
     * Sets the attribute lfnint32Min.
     *
     * @param lfnint32Min value of lfnint32Min
     */
    void lfnint32Min(int lfnint32Min);

    /**
     * Sets the attribute lfnint32Max.
     *
     * @param lfnint32Max value of lfnint32Max
     */
    void lfnint32Max(int lfnint32Max);

    /**
     * Sets the attribute lfnint64Min.
     *
     * @param lfnint64Min value of lfnint64Min
     */
    void lfnint64Min(long lfnint64Min);

    /**
     * Sets the attribute lfnint64Max.
     *
     * @param lfnint64Max value of lfnint64Max
     */
    void lfnint64Max(long lfnint64Max);

    /**
     * Sets the attribute lfnuint8Max.
     *
     * @param lfnuint8Max value of lfnuint8Max
     */
    void lfnuint8Max(short lfnuint8Max);

    /**
     * Sets the attribute lfnuint16Max.
     *
     * @param lfnuint16Max value of lfnuint16Max
     */
    void lfnuint16Max(int lfnuint16Max);

    /**
     * Sets the attribute lfnuint32Max.
     *
     * @param lfnuint32Max value of lfnuint32Max
     */
    void lfnuint32Max(long lfnuint32Max);

    /**
     * Sets the attribute lfuint64Max.
     *
     * @param lfuint64Max value of lfuint64Max
     */
    void lfuint64Max(BigInteger lfuint64Max);

    /**
     * Sets the attribute lfstr.
     *
     * @param lfstr value of lfstr
     */
    void lfstr(String lfstr);

    /**
     * Sets the attribute lfstr1.
     *
     * @param lfstr1 value of lfstr1
     */
    void lfstr1(String lfstr1);

    /**
     * Sets the attribute lfbool1.
     *
     * @param lfbool1 value of lfbool1
     */
    void lfbool1(boolean lfbool1);

    /**
     * Sets the attribute lfbool2.
     *
     * @param lfbool2 value of lfbool2
     */
    void lfbool2(boolean lfbool2);

    /**
     * Sets the attribute lfbool3.
     *
     * @param lfbool3 value of lfbool3
     */
    void lfbool3(boolean lfbool3);

    /**
     * Sets the attribute lfdecimal1.
     *
     * @param lfdecimal1 value of lfdecimal1
     */
    void lfdecimal1(BigDecimal lfdecimal1);

    /**
     * Sets the attribute lfdecimal2.
     *
     * @param lfdecimal2 value of lfdecimal2
     */
    void lfdecimal2(BigDecimal lfdecimal2);

    /**
     * Sets the attribute lfdecimal3.
     *
     * @param lfdecimal3 value of lfdecimal3
     */
    void lfdecimal3(BigDecimal lfdecimal3);

    /**
     * Sets the attribute lfdecimal4.
     *
     * @param lfdecimal4 value of lfdecimal4
     */
    void lfdecimal4(BigDecimal lfdecimal4);

    /**
     * Sets the attribute lfdecimal6.
     *
     * @param lfdecimal6 value of lfdecimal6
     */
    void lfdecimal6(BigDecimal lfdecimal6);

    /**
     * Sets the attribute lfenum.
     *
     * @param lfenum value of lfenum
     */
    void lfenum(LfenumEnum lfenum);

    /**
     * Sets the attribute lfbits.
     *
     * @param lfbits value of lfbits
     */
    void lfbits(BitSet lfbits);

    /**
     * Sets the attribute lfbinary.
     *
     * @param lfbinary value of lfbinary
     */
    void lfbinary(byte[] lfbinary);

    /**
     * Sets the attribute lfref1.
     *
     * @param lfref1 value of lfref1
     */
    void lfref1(String lfref1);

    /**
     * Sets the attribute lfref2.
     *
     * @param lfref2 value of lfref2
     */
    void lfref2(byte lfref2);

    /**
     * Sets the attribute lfempty.
     *
     * @param lfempty value of lfempty
     */
    void lfempty(boolean lfempty);

    /**
     * Sets the attribute lfunion1.
     *
     * @param lfunion1 value of lfunion1
     */
    void lfunion1(Lfunion1Union lfunion1);

    /**
     * Sets the attribute lfunion2.
     *
     * @param lfunion2 value of lfunion2
     */
    void lfunion2(Lfunion2Union lfunion2);

    /**
     * Sets the attribute lfunion4.
     *
     * @param lfunion4 value of lfunion4
     */
    void lfunion4(Lfunion4Union lfunion4);

    /**
     * Sets the attribute lfunion5.
     *
     * @param lfunion5 value of lfunion5
     */
    void lfunion5(Lfunion5Union lfunion5);

    /**
     * Sets the attribute lfunion7.
     *
     * @param lfunion7 value of lfunion7
     */
    void lfunion7(Tpdfun3 lfunion7);

    /**
     * Sets the attribute lfunion8.
     *
     * @param lfunion8 value of lfunion8
     */
    void lfunion8(Lfunion8Union lfunion8);

    /**
     * Sets the attribute lfunion9.
     *
     * @param lfunion9 value of lfunion9
     */
    void lfunion9(Lfunion9Union lfunion9);

    /**
     * Sets the attribute lfunion10.
     *
     * @param lfunion10 value of lfunion10
     */
    void lfunion10(Lfunion10Union lfunion10);

    /**
     * Sets the attribute lfunion11.
     *
     * @param lfunion11 value of lfunion11
     */
    void lfunion11(Lfunion11Union lfunion11);

    /**
     * Sets the attribute lfunion12.
     *
     * @param lfunion12 value of lfunion12
     */
    void lfunion12(Tpdfun2 lfunion12);

    /**
     * Sets the attribute lfunion13.
     *
     * @param lfunion13 value of lfunion13
     */
    void lfunion13(Tpdfbit lfunion13);

    /**
     * Sets the attribute lfunion14.
     *
     * @param lfunion14 value of lfunion14
     */
    void lfunion14(Lfunion14Union lfunion14);

    /**
     * Sets the attribute identityref1.
     *
     * @param identityref1 value of identityref1
     */
    void identityref1(Class<? extends Iden> identityref1);

    /**
     * Sets the attribute lfenum1.
     *
     * @param lfenum1 value of lfenum1
     */
    void lfenum1(Tpdfun0 lfenum1);


    /**
     * Checks if the leaf value is set.
     *
     * @param leaf leaf whose value status needs to checked
     * @return result of leaf value set in object
     */
    boolean isLeafValueSet(LeafIdentifier leaf);
}