/*
 * Copyright 2017-present Open Networking Laboratory
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.simpledatatypes.rev20131112.simpledatatypes;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.BitSet;
import java.util.Objects;
import java.util.StringJoiner;
import org.onosproject.yang.gen.v1.simpledatatypes.rev20131112.simpledatatypes.cont.LfenumEnum;
import org.onosproject.yang.gen.v1.simpledatatypes.rev20131112.simpledatatypes.cont.Lfunion10Union;
import org.onosproject.yang.gen.v1.simpledatatypes.rev20131112.simpledatatypes.cont.Lfunion11Union;
import org.onosproject.yang.gen.v1.simpledatatypes.rev20131112.simpledatatypes.cont.Lfunion14Union;
import org.onosproject.yang.gen.v1.simpledatatypes.rev20131112.simpledatatypes.cont.Lfunion1Union;
import org.onosproject.yang.gen.v1.simpledatatypes.rev20131112.simpledatatypes.cont.Lfunion2Union;
import org.onosproject.yang.gen.v1.simpledatatypes.rev20131112.simpledatatypes.cont.Lfunion4Union;
import org.onosproject.yang.gen.v1.simpledatatypes.rev20131112.simpledatatypes.cont.Lfunion5Union;
import org.onosproject.yang.gen.v1.simpledatatypes.rev20131112.simpledatatypes.cont.Lfunion8Union;
import org.onosproject.yang.gen.v1.simpledatatypes.rev20131112.simpledatatypes.cont.Lfunion9Union;
import org.onosproject.yang.model.InnerModelObject;

/**
 * Represents the implementation of cont.
 *
 * <p>
 * valueLeafFlags identify the leafs whose value are explicitly set
 * Applicable in protocol edit and query operation.
 * </p>
 */
public class DefaultCont extends InnerModelObject implements Cont {
    protected byte lfnint8Min;
    protected byte lfnint8Max;
    protected short lfnint16Min;
    protected short lfnint16Max;
    protected int lfnint32Min;
    protected int lfnint32Max;
    protected long lfnint64Min;
    protected long lfnint64Max;
    protected short lfnuint8Max;
    protected int lfnuint16Max;
    protected long lfnuint32Max;
    protected BigInteger lfuint64Max;
    protected String lfstr;
    protected String lfstr1;
    protected boolean lfbool1;
    protected boolean lfbool2;
    protected boolean lfbool3;
    protected BigDecimal lfdecimal1;
    protected BigDecimal lfdecimal2;
    protected BigDecimal lfdecimal3;
    protected BigDecimal lfdecimal4;
    protected BigDecimal lfdecimal6;
    protected LfenumEnum lfenum;
    protected BitSet lfbits;
    protected byte[] lfbinary;
    protected String lfref1;
    protected byte lfref2;
    protected boolean lfempty;
    protected Lfunion1Union lfunion1;
    protected Lfunion2Union lfunion2;
    protected Lfunion4Union lfunion4;
    protected Lfunion5Union lfunion5;
    protected Tpdfun3 lfunion7;
    protected Lfunion8Union lfunion8;
    protected Lfunion9Union lfunion9;
    protected Lfunion10Union lfunion10;
    protected Lfunion11Union lfunion11;
    protected Tpdfun2 lfunion12;
    protected Tpdfbit lfunion13;
    protected Lfunion14Union lfunion14;
    protected Class<? extends Iden> identityref1;
    protected Tpdfun0 lfenum1;
    protected BitSet valueLeafFlags = new BitSet();

    @Override
    public byte lfnint8Min() {
        return lfnint8Min;
    }

    @Override
    public byte lfnint8Max() {
        return lfnint8Max;
    }

    @Override
    public short lfnint16Min() {
        return lfnint16Min;
    }

    @Override
    public short lfnint16Max() {
        return lfnint16Max;
    }

    @Override
    public int lfnint32Min() {
        return lfnint32Min;
    }

    @Override
    public int lfnint32Max() {
        return lfnint32Max;
    }

    @Override
    public long lfnint64Min() {
        return lfnint64Min;
    }

    @Override
    public long lfnint64Max() {
        return lfnint64Max;
    }

    @Override
    public short lfnuint8Max() {
        return lfnuint8Max;
    }

    @Override
    public int lfnuint16Max() {
        return lfnuint16Max;
    }

    @Override
    public long lfnuint32Max() {
        return lfnuint32Max;
    }

    @Override
    public BigInteger lfuint64Max() {
        return lfuint64Max;
    }

    @Override
    public String lfstr() {
        return lfstr;
    }

    @Override
    public String lfstr1() {
        return lfstr1;
    }

    @Override
    public boolean lfbool1() {
        return lfbool1;
    }

    @Override
    public boolean lfbool2() {
        return lfbool2;
    }

    @Override
    public boolean lfbool3() {
        return lfbool3;
    }

    @Override
    public BigDecimal lfdecimal1() {
        return lfdecimal1;
    }

    @Override
    public BigDecimal lfdecimal2() {
        return lfdecimal2;
    }

    @Override
    public BigDecimal lfdecimal3() {
        return lfdecimal3;
    }

    @Override
    public BigDecimal lfdecimal4() {
        return lfdecimal4;
    }

    @Override
    public BigDecimal lfdecimal6() {
        return lfdecimal6;
    }

    @Override
    public LfenumEnum lfenum() {
        return lfenum;
    }

    @Override
    public BitSet lfbits() {
        return lfbits;
    }

    @Override
    public byte[] lfbinary() {
        return lfbinary;
    }

    @Override
    public String lfref1() {
        return lfref1;
    }

    @Override
    public byte lfref2() {
        return lfref2;
    }

    @Override
    public boolean lfempty() {
        return lfempty;
    }

    @Override
    public Lfunion1Union lfunion1() {
        return lfunion1;
    }

    @Override
    public Lfunion2Union lfunion2() {
        return lfunion2;
    }

    @Override
    public Lfunion4Union lfunion4() {
        return lfunion4;
    }

    @Override
    public Lfunion5Union lfunion5() {
        return lfunion5;
    }

    @Override
    public Tpdfun3 lfunion7() {
        return lfunion7;
    }

    @Override
    public Lfunion8Union lfunion8() {
        return lfunion8;
    }

    @Override
    public Lfunion9Union lfunion9() {
        return lfunion9;
    }

    @Override
    public Lfunion10Union lfunion10() {
        return lfunion10;
    }

    @Override
    public Lfunion11Union lfunion11() {
        return lfunion11;
    }

    @Override
    public Tpdfun2 lfunion12() {
        return lfunion12;
    }

    @Override
    public Tpdfbit lfunion13() {
        return lfunion13;
    }

    @Override
    public Lfunion14Union lfunion14() {
        return lfunion14;
    }

    @Override
    public Class<? extends Iden> identityref1() {
        return identityref1;
    }

    @Override
    public Tpdfun0 lfenum1() {
        return lfenum1;
    }

    @Override
    public BitSet valueLeafFlags() {
        return valueLeafFlags;
    }

    @Override
    public void lfnint8Min(byte lfnint8Min) {
        valueLeafFlags.set(LeafIdentifier.LFNINT8MIN.getLeafIndex());
        this.lfnint8Min = lfnint8Min;
    }

    @Override
    public void lfnint8Max(byte lfnint8Max) {
        valueLeafFlags.set(LeafIdentifier.LFNINT8MAX.getLeafIndex());
        this.lfnint8Max = lfnint8Max;
    }

    @Override
    public void lfnint16Min(short lfnint16Min) {
        valueLeafFlags.set(LeafIdentifier.LFNINT16MIN.getLeafIndex());
        this.lfnint16Min = lfnint16Min;
    }

    @Override
    public void lfnint16Max(short lfnint16Max) {
        valueLeafFlags.set(LeafIdentifier.LFNINT16MAX.getLeafIndex());
        this.lfnint16Max = lfnint16Max;
    }

    @Override
    public void lfnint32Min(int lfnint32Min) {
        valueLeafFlags.set(LeafIdentifier.LFNINT32MIN.getLeafIndex());
        this.lfnint32Min = lfnint32Min;
    }

    @Override
    public void lfnint32Max(int lfnint32Max) {
        valueLeafFlags.set(LeafIdentifier.LFNINT32MAX.getLeafIndex());
        this.lfnint32Max = lfnint32Max;
    }

    @Override
    public void lfnint64Min(long lfnint64Min) {
        valueLeafFlags.set(LeafIdentifier.LFNINT64MIN.getLeafIndex());
        this.lfnint64Min = lfnint64Min;
    }

    @Override
    public void lfnint64Max(long lfnint64Max) {
        valueLeafFlags.set(LeafIdentifier.LFNINT64MAX.getLeafIndex());
        this.lfnint64Max = lfnint64Max;
    }

    @Override
    public void lfnuint8Max(short lfnuint8Max) {
        valueLeafFlags.set(LeafIdentifier.LFNUINT8MAX.getLeafIndex());
        this.lfnuint8Max = lfnuint8Max;
    }

    @Override
    public void lfnuint16Max(int lfnuint16Max) {
        valueLeafFlags.set(LeafIdentifier.LFNUINT16MAX.getLeafIndex());
        this.lfnuint16Max = lfnuint16Max;
    }

    @Override
    public void lfnuint32Max(long lfnuint32Max) {
        valueLeafFlags.set(LeafIdentifier.LFNUINT32MAX.getLeafIndex());
        this.lfnuint32Max = lfnuint32Max;
    }

    @Override
    public void lfuint64Max(BigInteger lfuint64Max) {
        valueLeafFlags.set(LeafIdentifier.LFUINT64MAX.getLeafIndex());
        this.lfuint64Max = lfuint64Max;
    }

    @Override
    public void lfstr(String lfstr) {
        valueLeafFlags.set(LeafIdentifier.LFSTR.getLeafIndex());
        this.lfstr = lfstr;
    }

    @Override
    public void lfstr1(String lfstr1) {
        valueLeafFlags.set(LeafIdentifier.LFSTR1.getLeafIndex());
        this.lfstr1 = lfstr1;
    }

    @Override
    public void lfbool1(boolean lfbool1) {
        valueLeafFlags.set(LeafIdentifier.LFBOOL1.getLeafIndex());
        this.lfbool1 = lfbool1;
    }

    @Override
    public void lfbool2(boolean lfbool2) {
        valueLeafFlags.set(LeafIdentifier.LFBOOL2.getLeafIndex());
        this.lfbool2 = lfbool2;
    }

    @Override
    public void lfbool3(boolean lfbool3) {
        valueLeafFlags.set(LeafIdentifier.LFBOOL3.getLeafIndex());
        this.lfbool3 = lfbool3;
    }

    @Override
    public void lfdecimal1(BigDecimal lfdecimal1) {
        valueLeafFlags.set(LeafIdentifier.LFDECIMAL1.getLeafIndex());
        this.lfdecimal1 = lfdecimal1;
    }

    @Override
    public void lfdecimal2(BigDecimal lfdecimal2) {
        valueLeafFlags.set(LeafIdentifier.LFDECIMAL2.getLeafIndex());
        this.lfdecimal2 = lfdecimal2;
    }

    @Override
    public void lfdecimal3(BigDecimal lfdecimal3) {
        valueLeafFlags.set(LeafIdentifier.LFDECIMAL3.getLeafIndex());
        this.lfdecimal3 = lfdecimal3;
    }

    @Override
    public void lfdecimal4(BigDecimal lfdecimal4) {
        valueLeafFlags.set(LeafIdentifier.LFDECIMAL4.getLeafIndex());
        this.lfdecimal4 = lfdecimal4;
    }

    @Override
    public void lfdecimal6(BigDecimal lfdecimal6) {
        valueLeafFlags.set(LeafIdentifier.LFDECIMAL6.getLeafIndex());
        this.lfdecimal6 = lfdecimal6;
    }

    @Override
    public void lfenum(LfenumEnum lfenum) {
        valueLeafFlags.set(LeafIdentifier.LFENUM.getLeafIndex());
        this.lfenum = lfenum;
    }

    @Override
    public void lfbits(BitSet lfbits) {
        valueLeafFlags.set(LeafIdentifier.LFBITS.getLeafIndex());
        this.lfbits = lfbits;
    }

    @Override
    public void lfbinary(byte[] lfbinary) {
        valueLeafFlags.set(LeafIdentifier.LFBINARY.getLeafIndex());
        this.lfbinary = lfbinary;
    }

    @Override
    public void lfref1(String lfref1) {
        valueLeafFlags.set(LeafIdentifier.LFREF1.getLeafIndex());
        this.lfref1 = lfref1;
    }

    @Override
    public void lfref2(byte lfref2) {
        valueLeafFlags.set(LeafIdentifier.LFREF2.getLeafIndex());
        this.lfref2 = lfref2;
    }

    @Override
    public void lfempty(boolean lfempty) {
        valueLeafFlags.set(LeafIdentifier.LFEMPTY.getLeafIndex());
        this.lfempty = lfempty;
    }

    @Override
    public void lfunion1(Lfunion1Union lfunion1) {
        valueLeafFlags.set(LeafIdentifier.LFUNION1.getLeafIndex());
        this.lfunion1 = lfunion1;
    }

    @Override
    public void lfunion2(Lfunion2Union lfunion2) {
        valueLeafFlags.set(LeafIdentifier.LFUNION2.getLeafIndex());
        this.lfunion2 = lfunion2;
    }

    @Override
    public void lfunion4(Lfunion4Union lfunion4) {
        valueLeafFlags.set(LeafIdentifier.LFUNION4.getLeafIndex());
        this.lfunion4 = lfunion4;
    }

    @Override
    public void lfunion5(Lfunion5Union lfunion5) {
        valueLeafFlags.set(LeafIdentifier.LFUNION5.getLeafIndex());
        this.lfunion5 = lfunion5;
    }

    @Override
    public void lfunion7(Tpdfun3 lfunion7) {
        valueLeafFlags.set(LeafIdentifier.LFUNION7.getLeafIndex());
        this.lfunion7 = lfunion7;
    }

    @Override
    public void lfunion8(Lfunion8Union lfunion8) {
        valueLeafFlags.set(LeafIdentifier.LFUNION8.getLeafIndex());
        this.lfunion8 = lfunion8;
    }

    @Override
    public void lfunion9(Lfunion9Union lfunion9) {
        valueLeafFlags.set(LeafIdentifier.LFUNION9.getLeafIndex());
        this.lfunion9 = lfunion9;
    }

    @Override
    public void lfunion10(Lfunion10Union lfunion10) {
        valueLeafFlags.set(LeafIdentifier.LFUNION10.getLeafIndex());
        this.lfunion10 = lfunion10;
    }

    @Override
    public void lfunion11(Lfunion11Union lfunion11) {
        valueLeafFlags.set(LeafIdentifier.LFUNION11.getLeafIndex());
        this.lfunion11 = lfunion11;
    }

    @Override
    public void lfunion12(Tpdfun2 lfunion12) {
        valueLeafFlags.set(LeafIdentifier.LFUNION12.getLeafIndex());
        this.lfunion12 = lfunion12;
    }

    @Override
    public void lfunion13(Tpdfbit lfunion13) {
        valueLeafFlags.set(LeafIdentifier.LFUNION13.getLeafIndex());
        this.lfunion13 = lfunion13;
    }

    @Override
    public void lfunion14(Lfunion14Union lfunion14) {
        valueLeafFlags.set(LeafIdentifier.LFUNION14.getLeafIndex());
        this.lfunion14 = lfunion14;
    }

    @Override
    public void identityref1(Class<? extends Iden> identityref1) {
        valueLeafFlags.set(LeafIdentifier.IDENTITYREF1.getLeafIndex());
        this.identityref1 = identityref1;
    }

    @Override
    public void lfenum1(Tpdfun0 lfenum1) {
        valueLeafFlags.set(LeafIdentifier.LFENUM1.getLeafIndex());
        this.lfenum1 = lfenum1;
    }

    @Override
    public int hashCode() {
        return Objects.hash(lfnint8Min, lfnint8Max, lfnint16Min, lfnint16Max, lfnint32Min, lfnint32Max, lfnint64Min, lfnint64Max, lfnuint8Max, lfnuint16Max, lfnuint32Max, lfuint64Max, lfstr, lfstr1, lfbool1, lfbool2, lfbool3, lfdecimal1, lfdecimal2, lfdecimal3, lfdecimal4, lfdecimal6, lfenum, lfbits, lfbinary, lfref1, lfref2, lfempty, lfunion1, lfunion2, lfunion4, lfunion5, lfunion7, lfunion8, lfunion9, lfunion10, lfunion11, lfunion12, lfunion13, lfunion14, identityref1, lfenum1, valueLeafFlags);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof DefaultCont) {
            DefaultCont other = (DefaultCont) obj;
            return
                Objects.equals(lfnint8Min, other.lfnint8Min) &&
                Objects.equals(lfnint8Max, other.lfnint8Max) &&
                Objects.equals(lfnint16Min, other.lfnint16Min) &&
                Objects.equals(lfnint16Max, other.lfnint16Max) &&
                Objects.equals(lfnint32Min, other.lfnint32Min) &&
                Objects.equals(lfnint32Max, other.lfnint32Max) &&
                Objects.equals(lfnint64Min, other.lfnint64Min) &&
                Objects.equals(lfnint64Max, other.lfnint64Max) &&
                Objects.equals(lfnuint8Max, other.lfnuint8Max) &&
                Objects.equals(lfnuint16Max, other.lfnuint16Max) &&
                Objects.equals(lfnuint32Max, other.lfnuint32Max) &&
                Objects.equals(lfuint64Max, other.lfuint64Max) &&
                Objects.equals(lfstr, other.lfstr) &&
                Objects.equals(lfstr1, other.lfstr1) &&
                Objects.equals(lfbool1, other.lfbool1) &&
                Objects.equals(lfbool2, other.lfbool2) &&
                Objects.equals(lfbool3, other.lfbool3) &&
                Objects.equals(lfdecimal1, other.lfdecimal1) &&
                Objects.equals(lfdecimal2, other.lfdecimal2) &&
                Objects.equals(lfdecimal3, other.lfdecimal3) &&
                Objects.equals(lfdecimal4, other.lfdecimal4) &&
                Objects.equals(lfdecimal6, other.lfdecimal6) &&
                Objects.equals(lfenum, other.lfenum) &&
                Objects.equals(lfbits, other.lfbits) &&
                Objects.equals(lfbinary, other.lfbinary) &&
                Objects.equals(lfref1, other.lfref1) &&
                Objects.equals(lfref2, other.lfref2) &&
                Objects.equals(lfempty, other.lfempty) &&
                Objects.equals(lfunion1, other.lfunion1) &&
                Objects.equals(lfunion2, other.lfunion2) &&
                Objects.equals(lfunion4, other.lfunion4) &&
                Objects.equals(lfunion5, other.lfunion5) &&
                Objects.equals(lfunion7, other.lfunion7) &&
                Objects.equals(lfunion8, other.lfunion8) &&
                Objects.equals(lfunion9, other.lfunion9) &&
                Objects.equals(lfunion10, other.lfunion10) &&
                Objects.equals(lfunion11, other.lfunion11) &&
                Objects.equals(lfunion12, other.lfunion12) &&
                Objects.equals(lfunion13, other.lfunion13) &&
                Objects.equals(lfunion14, other.lfunion14) &&
                Objects.equals(identityref1, other.identityref1) &&
                Objects.equals(lfenum1, other.lfenum1) &&
                Objects.equals(valueLeafFlags, other.valueLeafFlags);
        }
        return false;
    }

    @Override
    public String toString() {
        return new StringJoiner(", ", getClass().getSimpleName() +"{", "}")
            .add("lfnint8Min=" + lfnint8Min)
            .add("lfnint8Max=" + lfnint8Max)
            .add("lfnint16Min=" + lfnint16Min)
            .add("lfnint16Max=" + lfnint16Max)
            .add("lfnint32Min=" + lfnint32Min)
            .add("lfnint32Max=" + lfnint32Max)
            .add("lfnint64Min=" + lfnint64Min)
            .add("lfnint64Max=" + lfnint64Max)
            .add("lfnuint8Max=" + lfnuint8Max)
            .add("lfnuint16Max=" + lfnuint16Max)
            .add("lfnuint32Max=" + lfnuint32Max)
            .add("lfuint64Max=" + lfuint64Max)
            .add("lfstr=" + lfstr)
            .add("lfstr1=" + lfstr1)
            .add("lfbool1=" + lfbool1)
            .add("lfbool2=" + lfbool2)
            .add("lfbool3=" + lfbool3)
            .add("lfdecimal1=" + lfdecimal1)
            .add("lfdecimal2=" + lfdecimal2)
            .add("lfdecimal3=" + lfdecimal3)
            .add("lfdecimal4=" + lfdecimal4)
            .add("lfdecimal6=" + lfdecimal6)
            .add("lfenum=" + lfenum)
            .add("lfbits=" + lfbits)
            .add("lfbinary=" + lfbinary)
            .add("lfref1=" + lfref1)
            .add("lfref2=" + lfref2)
            .add("lfempty=" + lfempty)
            .add("lfunion1=" + lfunion1)
            .add("lfunion2=" + lfunion2)
            .add("lfunion4=" + lfunion4)
            .add("lfunion5=" + lfunion5)
            .add("lfunion7=" + lfunion7)
            .add("lfunion8=" + lfunion8)
            .add("lfunion9=" + lfunion9)
            .add("lfunion10=" + lfunion10)
            .add("lfunion11=" + lfunion11)
            .add("lfunion12=" + lfunion12)
            .add("lfunion13=" + lfunion13)
            .add("lfunion14=" + lfunion14)
            .add("identityref1=" + identityref1)
            .add("lfenum1=" + lfenum1)
            .add("valueLeafFlags=" + valueLeafFlags)
            .toString();
    }


    /**
     * Creates an instance of defaultCont.
     */
    public DefaultCont() {
    }


    @Override
    public boolean isLeafValueSet(LeafIdentifier leaf) {
        return valueLeafFlags.get(leaf.getLeafIndex());
    }

}