/*
 * Copyright 2017-present Open Networking Laboratory
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.simpledatatypesll.rev20131112.simpledatatypesll.cont1;

import org.onosproject.yang.gen.v1.simpledatatypesll.rev20131112.simpledatatypesll.Tpdfun1;
import org.onosproject.yang.gen.v1.simpledatatypesll.rev20131112.simpledatatypesll.Tpdfun2;
import java.util.Objects;
import java.util.BitSet;

/**
 * Represents the implementation of lfunion11Union.
 */
public final class Lfunion11Union {
    private Tpdfun1 tpdfun1;
    private Tpdfun2 tpdfun2;
    private BitSet setValue = new BitSet();

    /**
     * Creates an instance of lfunion11Union.
     */
    private Lfunion11Union() {
    }

    /**
     * Creates an instance of tpdfun1.
     *
     * @param tpdfun1 value of tpdfun1
     */
    public Lfunion11Union(Tpdfun1 tpdfun1) {
        setValue.set(0);
        this.tpdfun1 = tpdfun1;
    }

    /**
     * Creates an instance of tpdfun2.
     *
     * @param tpdfun2 value of tpdfun2
     */
    public Lfunion11Union(Tpdfun2 tpdfun2) {
        setValue.set(1);
        this.tpdfun2 = tpdfun2;
    }

    /**
     * Returns the object of lfunion11Union for type tpdfun1.
     *
     * @param value value of lfunion11Union for type tpdfun1
     * @return lfunion11Union for type tpdfun1
     */
    public static Lfunion11Union of(Tpdfun1 value) {
        return new Lfunion11Union(value);
    }

    /**
     * Returns the object of lfunion11Union for type tpdfun2.
     *
     * @param value value of lfunion11Union for type tpdfun2
     * @return lfunion11Union for type tpdfun2
     */
    public static Lfunion11Union of(Tpdfun2 value) {
        return new Lfunion11Union(value);
    }

    /**
     * Returns the attribute tpdfun1.
     *
     * @return tpdfun1 value of tpdfun1
     */
    public Tpdfun1 tpdfun1() {
        return tpdfun1;
    }
    /**
     * Returns the attribute tpdfun2.
     *
     * @return tpdfun2 value of tpdfun2
     */
    public Tpdfun2 tpdfun2() {
        return tpdfun2;
    }
    /**
     * Sets the attribute tpdfun1.
     *
     * @param tpdfun1 value of tpdfun1
     */
    public void tpdfun1(Tpdfun1 tpdfun1) {
        this.tpdfun1 = tpdfun1;
    }
    /**
     * Sets the attribute tpdfun2.
     *
     * @param tpdfun2 value of tpdfun2
     */
    public void tpdfun2(Tpdfun2 tpdfun2) {
        this.tpdfun2 = tpdfun2;
    }

    @Override
    public int hashCode() {
        return Objects.hash(tpdfun1, tpdfun2);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof Lfunion11Union) {
            Lfunion11Union other = (Lfunion11Union) obj;
            return
                Objects.equals(tpdfun1, other.tpdfun1) &&
                Objects.equals(tpdfun2, other.tpdfun2);
        }
        return false;
    }

    @Override
    public String toString() {
        if (setValue.get(0)) {
            return tpdfun1.toString();
        }
        if (setValue.get(1)) {
            return tpdfun2.toString();
        }
        return null;
    }
    /**
     * Returns the object of lfunion11Union fromString input String lfunion11Union.
     *
     * @param valInString value of input String
     * @return lfunion11Union
     */
    public static Lfunion11Union fromString(String valInString) {
        try {
            Tpdfun1 tmpVal = Tpdfun1.fromString(valInString);
            return of(tmpVal);
        } catch (Exception e) {
        }
        try {
            Tpdfun2 tmpVal = Tpdfun2.fromString(valInString);
            return of(tmpVal);
        } catch (Exception e) {
            throw new IllegalArgumentException("not a valid input element");
        }
    }
}
