/*
 * Copyright 2017-present Open Networking Laboratory
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.simpledatatypesll.rev20131112.simpledatatypesll.cont1;

import java.util.Objects;
import java.util.BitSet;

/**
 * Represents the implementation of lfunion5Union.
 */
public final class Lfunion5Union {
    private int uint16;
    private String string;
    private BitSet setValue = new BitSet();

    /**
     * Creates an instance of lfunion5Union.
     */
    private Lfunion5Union() {
    }

    /**
     * Creates an instance of uint16.
     *
     * @param uint16 value of uint16
     */
    public Lfunion5Union(int uint16) {
        setValue.set(0);
        this.uint16 = uint16;
    }

    /**
     * Creates an instance of string.
     *
     * @param string value of string
     */
    public Lfunion5Union(String string) {
        setValue.set(1);
        this.string = string;
    }

    /**
     * Returns the object of lfunion5Union for type uint16.
     *
     * @param value value of lfunion5Union for type uint16
     * @return lfunion5Union for type uint16
     */
    public static Lfunion5Union of(int value) {
        return new Lfunion5Union(value);
    }

    /**
     * Returns the object of lfunion5Union for type string.
     *
     * @param value value of lfunion5Union for type string
     * @return lfunion5Union for type string
     */
    public static Lfunion5Union of(String value) {
        return new Lfunion5Union(value);
    }

    /**
     * Returns the attribute uint16.
     *
     * @return uint16 value of uint16
     */
    public int uint16() {
        return uint16;
    }
    /**
     * Returns the attribute string.
     *
     * @return string value of string
     */
    public String string() {
        return string;
    }
    /**
     * Sets the attribute uint16.
     *
     * @param uint16 value of uint16
     */
    public void uint16(int uint16) {
        this.uint16 = uint16;
    }
    /**
     * Sets the attribute string.
     *
     * @param string value of string
     */
    public void string(String string) {
        this.string = string;
    }

    @Override
    public int hashCode() {
        return Objects.hash(uint16, string);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof Lfunion5Union) {
            Lfunion5Union other = (Lfunion5Union) obj;
            return
                Objects.equals(uint16, other.uint16) &&
                Objects.equals(string, other.string);
        }
        return false;
    }

    @Override
    public String toString() {
        if (setValue.get(0)) {
            return String.valueOf(uint16);
        }
        if (setValue.get(1)) {
            return string;
        }
        return null;
    }
    /**
     * Returns the object of lfunion5Union fromString input String lfunion5Union.
     *
     * @param valInString value of input String
     * @return lfunion5Union
     */
    public static Lfunion5Union fromString(String valInString) {
        try {
            int tmpVal = Integer.parseInt(valInString);
            return of(tmpVal);
        } catch (Exception e) {
        }
        try {
            String tmpVal = (valInString);
            return of(tmpVal);
        } catch (Exception e) {
            throw new IllegalArgumentException("not a valid input element");
        }
    }
}
