/*
 * Copyright 2017-present Open Networking Laboratory
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.yrtietfinettypes.rev20130715.yrtietfinettypes;

import org.onosproject.yang.gen.v1.yrtietfinettypes.rev20130715.yrtietfinettypes.ipprefix.IpPrefixUnion;
import java.util.Objects;

/**
 * Represents the implementation of ipPrefix.
 */
public final class IpPrefix {

    private IpPrefixUnion union;

    /**
     * Creates an instance of ipPrefix.
     */
    private IpPrefix() {
    }

    /**
     * Creates an instance of union.
     *
     * @param union value of union
     */
    public IpPrefix(IpPrefixUnion union) {
        this.union = union;
    }

    /**
     * Returns the object of ipPrefix for type union.
     *
     * @param value value of ipPrefix for type union
     * @return ipPrefix for type union
     */
    public static IpPrefix of(IpPrefixUnion value) {
        return new IpPrefix(value);
    }

    /**
     * Returns the attribute union.
     *
     * @return union value of union
     */
    public IpPrefixUnion union() {
        return union;
    }
    /**
     * Sets the attribute union.
     *
     * @param union value of union
     */
    public void union(IpPrefixUnion union) {
        this.union = union;
    }

    @Override
    public int hashCode() {
        return Objects.hash(union);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof IpPrefix) {
            IpPrefix other = (IpPrefix) obj;
            return
                Objects.equals(union, other.union);
        }
        return false;
    }

    @Override
    public String toString() {
        return union.toString();
    }
    /**
     * Returns the object of ipPrefix fromString input String ipPrefix.
     *
     * @param valInString value of input String
     * @return ipPrefix
     */
    public static IpPrefix fromString(String valInString) {
        try {
            IpPrefixUnion tmpVal = IpPrefixUnion.fromString(valInString);
            return of(tmpVal);
        } catch (Exception e) {
            throw new IllegalArgumentException("not a valid input element");
        }
    }
}
