/*
 * Copyright 2017-present Open Networking Laboratory
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.yrtietftetopology.rev20160317.yrtietftetopology.telinkstatederived;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.BitSet;
import java.util.List;
import org.onosproject.yang.gen.v1.yrtietftetopology.rev20160317.yrtietftetopology.informationsourceattributes.InformationSourceEnum;
import org.onosproject.yang.gen.v1.yrtietftetopology.rev20160317.yrtietftetopology.informationsourceattributes.InformationSourceState;
import org.onosproject.yang.gen.v1.yrtietftetopology.rev20160317.yrtietftetopology.telinkinfoattributes.InterfaceSwitchingCapability;
import org.onosproject.yang.gen.v1.yrtietftetopology.rev20160317.yrtietftetopology.telinkinfoattributes.LinkProtectionTypeEnum;
import org.onosproject.yang.gen.v1.yrtietftetopology.rev20160317.yrtietftetopology.telinkinfoattributes.PerformanceMetric;
import org.onosproject.yang.gen.v1.yrtietftetopology.rev20160317.yrtietftetopology.telinkinfoattributes.TeSrlgs;
import org.onosproject.yang.gen.v1.yrtietftetopology.rev20160317.yrtietftetopology.telinkinfoattributes.UnreservedBandwidth;
import org.onosproject.yang.gen.v1.yrtietftetypes.rev20160320.yrtietftetypes.AdminGroups;
import org.onosproject.yang.model.Augmentable;

/**
 * Abstraction of an entity which represents the functionality of altInformationSources.
 */
public interface AltInformationSources extends Augmentable  {

    /**
     * Identify the leaf of AltInformationSources.
     */
    public enum LeafIdentifier implements org.onosproject.yang.model.LeafIdentifier{
        /**
         * Represents linkIndex.
         */
        LINKINDEX(1),
        /**
         * Represents administrativeGroup.
         */
        ADMINISTRATIVEGROUP(2),
        /**
         * Represents maxLinkBandwidth.
         */
        MAXLINKBANDWIDTH(3),
        /**
         * Represents maxResvLinkBandwidth.
         */
        MAXRESVLINKBANDWIDTH(4),
        /**
         * Represents teDefaultMetric.
         */
        TEDEFAULTMETRIC(5),
        /**
         * Represents linkProtectionType.
         */
        LINKPROTECTIONTYPE(6),
        /**
         * Represents informationSource.
         */
        INFORMATIONSOURCE(7);

        private int leafIndex;

        public int getLeafIndex() {
            return leafIndex;
        }

        LeafIdentifier(int value) {
            this.leafIndex = value;
        }
    }

    /**
     * Returns the attribute linkIndex.
     *
     * @return linkIndex value of linkIndex
     */
    BigInteger linkIndex();

    /**
     * Returns the attribute administrativeGroup.
     *
     * @return administrativeGroup value of administrativeGroup
     */
    AdminGroups administrativeGroup();

    /**
     * Returns the attribute maxLinkBandwidth.
     *
     * @return maxLinkBandwidth value of maxLinkBandwidth
     */
    BigDecimal maxLinkBandwidth();

    /**
     * Returns the attribute maxResvLinkBandwidth.
     *
     * @return maxResvLinkBandwidth value of maxResvLinkBandwidth
     */
    BigDecimal maxResvLinkBandwidth();

    /**
     * Returns the attribute teDefaultMetric.
     *
     * @return teDefaultMetric value of teDefaultMetric
     */
    long teDefaultMetric();

    /**
     * Returns the attribute linkProtectionType.
     *
     * @return linkProtectionType value of linkProtectionType
     */
    LinkProtectionTypeEnum linkProtectionType();

    /**
     * Returns the attribute informationSource.
     *
     * @return informationSource value of informationSource
     */
    InformationSourceEnum informationSource();

    /**
     * Returns the attribute valueLeafFlags.
     *
     * @return valueLeafFlags value of valueLeafFlags
     */
    BitSet valueLeafFlags();

    /**
     * Returns the attribute unreservedBandwidth.
     *
     * @return unreservedBandwidth list of unreservedBandwidth
     */
    List<UnreservedBandwidth> unreservedBandwidth();

    /**
     * Returns the attribute performanceMetric.
     *
     * @return performanceMetric value of performanceMetric
     */
    PerformanceMetric performanceMetric();

    /**
     * Returns the attribute interfaceSwitchingCapability.
     *
     * @return interfaceSwitchingCapability list of interfaceSwitchingCapability
     */
    List<InterfaceSwitchingCapability> interfaceSwitchingCapability();

    /**
     * Returns the attribute teSrlgs.
     *
     * @return teSrlgs value of teSrlgs
     */
    TeSrlgs teSrlgs();

    /**
     * Returns the attribute informationSourceState.
     *
     * @return informationSourceState value of informationSourceState
     */
    InformationSourceState informationSourceState();

    /**
     * Sets the attribute linkIndex.
     *
     * @param linkIndex value of linkIndex
     */
    void linkIndex(BigInteger linkIndex);

    /**
     * Sets the attribute administrativeGroup.
     *
     * @param administrativeGroup value of administrativeGroup
     */
    void administrativeGroup(AdminGroups administrativeGroup);

    /**
     * Sets the attribute maxLinkBandwidth.
     *
     * @param maxLinkBandwidth value of maxLinkBandwidth
     */
    void maxLinkBandwidth(BigDecimal maxLinkBandwidth);

    /**
     * Sets the attribute maxResvLinkBandwidth.
     *
     * @param maxResvLinkBandwidth value of maxResvLinkBandwidth
     */
    void maxResvLinkBandwidth(BigDecimal maxResvLinkBandwidth);

    /**
     * Sets the attribute teDefaultMetric.
     *
     * @param teDefaultMetric value of teDefaultMetric
     */
    void teDefaultMetric(long teDefaultMetric);

    /**
     * Sets the attribute linkProtectionType.
     *
     * @param linkProtectionType value of linkProtectionType
     */
    void linkProtectionType(LinkProtectionTypeEnum linkProtectionType);

    /**
     * Sets the attribute informationSource.
     *
     * @param informationSource value of informationSource
     */
    void informationSource(InformationSourceEnum informationSource);

    /**
     * Sets the attribute unreservedBandwidth.
     *
     * @param unreservedBandwidth list of unreservedBandwidth
     */
    void unreservedBandwidth(List<UnreservedBandwidth> unreservedBandwidth);

    /**
     * Sets the attribute performanceMetric.
     *
     * @param performanceMetric value of performanceMetric
     */
    void performanceMetric(PerformanceMetric performanceMetric);

    /**
     * Sets the attribute interfaceSwitchingCapability.
     *
     * @param interfaceSwitchingCapability list of interfaceSwitchingCapability
     */
    void interfaceSwitchingCapability(List<InterfaceSwitchingCapability> interfaceSwitchingCapability);

    /**
     * Sets the attribute teSrlgs.
     *
     * @param teSrlgs value of teSrlgs
     */
    void teSrlgs(TeSrlgs teSrlgs);

    /**
     * Sets the attribute informationSourceState.
     *
     * @param informationSourceState value of informationSourceState
     */
    void informationSourceState(InformationSourceState informationSourceState);

    /**
     * Adds to the list of unreservedBandwidth.
     *
     * @param addTo value of unreservedBandwidth
     */
    void addToUnreservedBandwidth(UnreservedBandwidth addTo);

    /**
     * Adds to the list of interfaceSwitchingCapability.
     *
     * @param addTo value of interfaceSwitchingCapability
     */
    void addToInterfaceSwitchingCapability(InterfaceSwitchingCapability addTo);


    /**
     * Checks if the leaf value is set.
     *
     * @param leaf leaf whose value status needs to checked
     * @return result of leaf value set in object
     */
    boolean isLeafValueSet(LeafIdentifier leaf);
}