/*
 * Copyright 2017-present Open Networking Laboratory
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.yrtietftetypes.rev20160320.yrtietftetypes;
/**
 * Represents the implementation of resourceAffinitiesType.
 */
public abstract class ResourceAffinitiesType {

    /**
     * Returns the attribute resource-affinities-type.
     *
     * @return resource-affinities-type value of resource-affinities-type
     */
    public static String resourceAffinitiesTypeToString() {
        return "resource-affinities-type";
    }

    /**
     * Returns the object of resourceAffinitiesType fromString input String resourceAffinitiesType.
     *
     * @param valInString value of input String
     * @return resourceAffinitiesType
     */
    public static Class fromString(String valInString) {
        if (valInString.equals("resource-affinities-type")) {
            return ResourceAffinitiesType.class;
        }
        throw new IllegalArgumentException("not a valid input element");
    }
}