/*
 * Copyright 2017-present Open Networking Laboratory
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.yrtietftetypes.rev20160320.yrtietftetypes.explicitroutesubobject.type;

import java.util.BitSet;
import org.onosproject.yang.gen.v1.yrtietftetypes.rev20160320.yrtietftetypes.explicitroutesubobject.Type;
import org.onosproject.yang.model.Augmentable;

/**
 * Abstraction of an entity which represents the functionality of ipv4Address.
 */
public interface Ipv4Address extends Type, Augmentable  {

    /**
     * Identify the leaf of Ipv4Address.
     */
    public enum LeafIdentifier implements org.onosproject.yang.model.LeafIdentifier{
        /**
         * Represents v4Address.
         */
        V4ADDRESS(1),
        /**
         * Represents v4PrefixLength.
         */
        V4PREFIXLENGTH(2),
        /**
         * Represents v4Loose.
         */
        V4LOOSE(3);

        private int leafIndex;

        public int getLeafIndex() {
            return leafIndex;
        }

        LeafIdentifier(int value) {
            this.leafIndex = value;
        }
    }

    /**
     * Returns the attribute v4Address.
     *
     * @return v4Address value of v4Address
     */
    org.onosproject.yang.gen.v1.yrtietfinettypes.rev20130715.yrtietfinettypes.Ipv4Address v4Address();

    /**
     * Returns the attribute v4PrefixLength.
     *
     * @return v4PrefixLength value of v4PrefixLength
     */
    short v4PrefixLength();

    /**
     * Returns the attribute v4Loose.
     *
     * @return v4Loose value of v4Loose
     */
    boolean v4Loose();

    /**
     * Returns the attribute valueLeafFlags.
     *
     * @return valueLeafFlags value of valueLeafFlags
     */
    BitSet valueLeafFlags();

    /**
     * Sets the attribute v4Address.
     *
     * @param v4Address value of v4Address
     */
    void v4Address(org.onosproject.yang.gen.v1.yrtietfinettypes.rev20130715.yrtietfinettypes.Ipv4Address v4Address);

    /**
     * Sets the attribute v4PrefixLength.
     *
     * @param v4PrefixLength value of v4PrefixLength
     */
    void v4PrefixLength(short v4PrefixLength);

    /**
     * Sets the attribute v4Loose.
     *
     * @param v4Loose value of v4Loose
     */
    void v4Loose(boolean v4Loose);


    /**
     * Checks if the leaf value is set.
     *
     * @param leaf leaf whose value status needs to checked
     * @return result of leaf value set in object
     */
    boolean isLeafValueSet(LeafIdentifier leaf);
}