/*
 * Copyright 2017-present Open Networking Laboratory
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.ytbdatatype.rev20160826.ytbdatatype.unionenumunion;

/**
 * Represents ENUM data of unionEnumUnionEnum1.
 */
public enum UnionEnumUnionEnum1 {

    /**
     * Represents ten.
     */
    TEN(10, "ten"),

    /**
     * Represents hundred.
     */
    HUNDRED(100, "hundred"),

    /**
     * Represents thousand.
     */
    THOUSAND(1000, "thousand");

    private int unionEnumUnionEnum1;
    private String schemaName;

    /**
     * Creates an instance of unionEnumUnionEnum1.
     *
     * @param unionEnumUnionEnum1 value of unionEnumUnionEnum1
     */
     UnionEnumUnionEnum1(int unionEnumUnionEnum1, String schemaName) {
        this.unionEnumUnionEnum1 = unionEnumUnionEnum1;
        this.schemaName = schemaName;
    }

    /**
     * Returns the object of unionEnumUnionEnum1 for.
     *
     * @param value value of unionEnumUnionEnum1 for
     * @return unionEnumUnionEnum1 for
     */
    public static UnionEnumUnionEnum1 of(int value) {
        switch (value) {
            case 10:
                return UnionEnumUnionEnum1.TEN;
            case 100:
                return UnionEnumUnionEnum1.HUNDRED;
            case 1000:
                return UnionEnumUnionEnum1.THOUSAND;
            default :
                throw new IllegalArgumentException("not a valid input element");
        }
    }
    /**
     * Returns the object of unionEnumUnionEnum1 for.
     *
     * @param value value of unionEnumUnionEnum1 for
     * @return unionEnumUnionEnum1 for
     */
    public static UnionEnumUnionEnum1 of(String value) {
        switch (value) {
            case "ten":
                return UnionEnumUnionEnum1.TEN;
            case "hundred":
                return UnionEnumUnionEnum1.HUNDRED;
            case "thousand":
                return UnionEnumUnionEnum1.THOUSAND;
            default :
                throw new IllegalArgumentException("not a valid input element");
        }
    }
    /**
     * Returns the attribute unionEnumUnionEnum1.
     *
     * @return unionEnumUnionEnum1 value of unionEnumUnionEnum1
     */
    public int unionEnumUnionEnum1() {
        return unionEnumUnionEnum1;
    }


    @Override
    public String toString() {
        return schemaName;
    }
}
