/*
 * Copyright 2017-present Open Networking Laboratory
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.ytbderivedtypewithbitsandbinary.rev20160826.ytbderivedtypewithbitsandbinary;

import java.util.Objects;

/**
 * Represents the implementation of derivedbitsa.
 */
public final class Derivedbitsa {

    private Derivedbitsb derivedbitsb;

    /**
     * Creates an instance of derivedbitsa.
     */
    private Derivedbitsa() {
    }

    /**
     * Creates an instance of derivedbitsb.
     *
     * @param derivedbitsb value of derivedbitsb
     */
    public Derivedbitsa(Derivedbitsb derivedbitsb) {
        this.derivedbitsb = derivedbitsb;
    }

    /**
     * Returns the object of derivedbitsa for type derivedbitsb.
     *
     * @param value value of derivedbitsa for type derivedbitsb
     * @return derivedbitsa for type derivedbitsb
     */
    public static Derivedbitsa of(Derivedbitsb value) {
        return new Derivedbitsa(value);
    }

    /**
     * Returns the attribute derivedbitsb.
     *
     * @return derivedbitsb value of derivedbitsb
     */
    public Derivedbitsb derivedbitsb() {
        return derivedbitsb;
    }
    /**
     * Sets the attribute derivedbitsb.
     *
     * @param derivedbitsb value of derivedbitsb
     */
    public void derivedbitsb(Derivedbitsb derivedbitsb) {
        this.derivedbitsb = derivedbitsb;
    }

    @Override
    public int hashCode() {
        return Objects.hash(derivedbitsb);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof Derivedbitsa) {
            Derivedbitsa other = (Derivedbitsa) obj;
            return
                Objects.equals(derivedbitsb, other.derivedbitsb);
        }
        return false;
    }

    @Override
    public String toString() {
        return derivedbitsb.toString();
    }
    /**
     * Returns the object of derivedbitsa fromString input String derivedbitsa.
     *
     * @param valInString value of input String
     * @return derivedbitsa
     */
    public static Derivedbitsa fromString(String valInString) {
        try {
            Derivedbitsb tmpVal = Derivedbitsb.fromString(valInString);
            return of(tmpVal);
        } catch (Exception e) {
            throw new IllegalArgumentException("not a valid input element");
        }
    }
}
