/*
 * Copyright 2017-present Open Networking Laboratory
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.ytbietfschedule.rev20160826;

import java.util.BitSet;
import java.util.List;
import org.onosproject.yang.gen.v1.ytbietfschedule.rev20160826.ytbietfschedule.Enum1Enum;
import org.onosproject.yang.gen.v1.ytbietfschedule.rev20160826.ytbietfschedule.Enum2Enum;
import org.onosproject.yang.gen.v1.ytbietfschedule.rev20160826.ytbietfschedule.Monitor;

/**
 * Abstraction of an entity which represents the functionality of ytbIetfSchedule.
 */
public interface YtbIetfSchedule {

    /**
     * Identify the leaf of YtbIetfSchedule.
     */
    public enum LeafIdentifier implements org.onosproject.yang.model.LeafIdentifier{
        /**
         * Represents time.
         */
        TIME(1),
        /**
         * Represents enum1.
         */
        ENUM1(2),
        /**
         * Represents enum2.
         */
        ENUM2(3);

        private int leafIndex;

        public int getLeafIndex() {
            return leafIndex;
        }

        LeafIdentifier(int value) {
            this.leafIndex = value;
        }
    }

    /**
     * Returns the attribute time.
     *
     * @return time value of time
     */
    byte time();

    /**
     * Returns the attribute enum1.
     *
     * @return enum1 value of enum1
     */
    Enum1Enum enum1();

    /**
     * Returns the attribute enum2.
     *
     * @return enum2 list of enum2
     */
    List<Enum2Enum> enum2();

    /**
     * Returns the attribute valueLeafFlags.
     *
     * @return valueLeafFlags value of valueLeafFlags
     */
    BitSet valueLeafFlags();

    /**
     * Returns the attribute monitor.
     *
     * @return monitor value of monitor
     */
    Monitor monitor();

    /**
     * Sets the attribute time.
     *
     * @param time value of time
     */
    void time(byte time);

    /**
     * Sets the attribute enum1.
     *
     * @param enum1 value of enum1
     */
    void enum1(Enum1Enum enum1);

    /**
     * Sets the attribute enum2.
     *
     * @param enum2 list of enum2
     */
    void enum2(List<Enum2Enum> enum2);

    /**
     * Sets the attribute monitor.
     *
     * @param monitor value of monitor
     */
    void monitor(Monitor monitor);

    /**
     * Adds to the list of enum2.
     *
     * @param addTo value of enum2
     */
    void addToEnum2(Enum2Enum addTo);


    /**
     * Checks if the leaf value is set.
     *
     * @param leaf leaf whose value status needs to checked
     * @return result of leaf value set in object
     */
    boolean isLeafValueSet(LeafIdentifier leaf);
}