/*
 * Copyright 2017-present Open Networking Laboratory
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.ytbsimpleaugment.rev20160826.ytbsimpleaugment;

import java.util.Objects;
import java.util.StringJoiner;
import org.onosproject.yang.gen.v1.ytbsimpleaugment.rev20160826.ytbsimpleaugment.cont1.Cont2;
import org.onosproject.yang.model.InnerModelObject;

/**
 * Represents the implementation of cont1.
 *
 * <p>
 * valueLeafFlags identify the leafs whose value are explicitly set
 * Applicable in protocol edit and query operation.
 * </p>
 */
public class DefaultCont1 extends InnerModelObject implements Cont1 {
    protected Cont2 cont2;

    @Override
    public Cont2 cont2() {
        return cont2;
    }

    @Override
    public void cont2(Cont2 cont2) {
        this.cont2 = cont2;
    }

    @Override
    public int hashCode() {
        return Objects.hash(cont2);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof DefaultCont1) {
            DefaultCont1 other = (DefaultCont1) obj;
            return
                Objects.equals(cont2, other.cont2);
        }
        return false;
    }

    @Override
    public String toString() {
        return new StringJoiner(", ", getClass().getSimpleName() +"{", "}")
            .add("cont2=" + cont2)
            .toString();
    }


    /**
     * Creates an instance of defaultCont1.
     */
    public DefaultCont1() {
    }

}