/*
 * Copyright 2017-present Open Networking Laboratory
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.ytbsimplechoicecase.rev20160826;

import java.util.Map;
import java.util.Objects;
import java.util.StringJoiner;
import org.onosproject.yang.gen.v1.ytbsimplechoicecase.rev20160826.ytbsimplechoicecase.YtbFood;
import org.onosproject.yang.model.InnerModelObject;

/**
 * Represents the implementation of ytbSimpleChoiceCase.
 *
 * <p>
 * valueLeafFlags identify the leafs whose value are explicitly set
 * Applicable in protocol edit and query operation.
 * </p>
 */
public class YtbSimpleChoiceCaseOpParam extends InnerModelObject implements YtbSimpleChoiceCase {
    protected YtbFood ytbFood;

    @Override
    public YtbFood ytbFood() {
        return ytbFood;
    }

    @Override
    public void ytbFood(YtbFood ytbFood) {
        this.ytbFood = ytbFood;
    }

    @Override
    public int hashCode() {
        return Objects.hash(ytbFood);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof YtbSimpleChoiceCaseOpParam) {
            YtbSimpleChoiceCaseOpParam other = (YtbSimpleChoiceCaseOpParam) obj;
            return
                Objects.equals(ytbFood, other.ytbFood);
        }
        return false;
    }

    @Override
    public String toString() {
        return new StringJoiner(", ", getClass().getSimpleName() +"{", "}")
            .add("ytbFood=" + ytbFood)
            .toString();
    }

    /**
     * Creates an instance of ytbSimpleChoiceCaseOpParam.
     */
    public YtbSimpleChoiceCaseOpParam() {
    }


    @Override
    public void addAugmentation(InnerModelObject obj) {
    }

    @Override
    public void removeAugmentation(InnerModelObject obj) {
    }

    @Override
    public Map<Class<? extends InnerModelObject>, InnerModelObject> augmentations() {

        return null;
    }

    @Override
    public <T extends InnerModelObject> T augmentation(Class<T> c) {

        return null;
    }
}