/*
 * Copyright 2017-present Open Networking Laboratory
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.ytbtreebuilderforlisthavinglist.rev20160826.ytbtreebuilderforlisthavinglist;

import java.util.List;
import org.onosproject.yang.gen.v1.ytbtreebuilderforlisthavinglist.rev20160826.ytbtreebuilderforlisthavinglist.carrier.Multiplexes;
import org.onosproject.yang.model.Augmentable;

/**
 * Abstraction of an entity which represents the functionality of carrier.
 */
public interface Carrier extends Augmentable  {

    /**
     * Returns the attribute multiplexes.
     *
     * @return multiplexes list of multiplexes
     */
    List<Multiplexes> multiplexes();

    /**
     * Sets the attribute multiplexes.
     *
     * @param multiplexes list of multiplexes
     */
    void multiplexes(List<Multiplexes> multiplexes);

    /**
     * Adds to the list of multiplexes.
     *
     * @param addTo value of multiplexes
     */
    void addToMultiplexes(Multiplexes addTo);

}