/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.yang.compiler.datamodel;

import com.google.common.base.Preconditions;
import java.io.Serializable;
import java.util.LinkedList;
import java.util.List;
import org.onosproject.yang.compiler.datamodel.BuiltInTypeObjectFactory;
import org.onosproject.yang.compiler.datamodel.DefaultLocationInfo;
import org.onosproject.yang.compiler.datamodel.YangAppErrorHolder;
import org.onosproject.yang.compiler.datamodel.YangAppErrorInfo;
import org.onosproject.yang.compiler.datamodel.YangDesc;
import org.onosproject.yang.compiler.datamodel.YangRangeInterval;
import org.onosproject.yang.compiler.datamodel.YangReference;
import org.onosproject.yang.compiler.datamodel.exceptions.DataModelException;
import org.onosproject.yang.compiler.datamodel.exceptions.ErrorMessages;
import org.onosproject.yang.compiler.datamodel.utils.Parsable;
import org.onosproject.yang.compiler.datamodel.utils.YangConstructType;
import org.onosproject.yang.compiler.datamodel.utils.builtindatatype.YangBuiltInDataTypeInfo;
import org.onosproject.yang.compiler.datamodel.utils.builtindatatype.YangDataTypes;

public class YangRangeRestriction<T extends YangBuiltInDataTypeInfo<T>>
extends DefaultLocationInfo
implements YangDesc,
YangReference,
Parsable,
Serializable,
YangAppErrorHolder {
    private static final long serialVersionUID = 8062016051L;
    private List<YangRangeInterval<T>> ascendingRangeIntervals;
    private String reference;
    private String description;
    private YangAppErrorInfo yangAppErrorInfo = new YangAppErrorInfo();

    public List<YangRangeInterval<T>> getAscendingRangeIntervals() {
        return this.ascendingRangeIntervals;
    }

    public T getMinRestrictedValue() throws DataModelException {
        if (this.getAscendingRangeIntervals() == null) {
            throw new DataModelException(ErrorMessages.getErrorMsg("No range restriction info ", "", this.getLineNumber(), this.getCharPosition(), this.getFileName() + "\""));
        }
        if (this.getAscendingRangeIntervals().isEmpty()) {
            throw new DataModelException(ErrorMessages.getErrorMsg("No range interval info ", "", this.getLineNumber(), this.getCharPosition(), this.getFileName() + "\""));
        }
        return this.getAscendingRangeIntervals().get(0).getStartValue();
    }

    public T getMaxRestrictedValue() throws DataModelException {
        if (this.getAscendingRangeIntervals() == null) {
            throw new DataModelException(ErrorMessages.getErrorMsg("No range restriction info ", "", this.getLineNumber(), this.getCharPosition(), this.getFileName() + "\""));
        }
        if (this.getAscendingRangeIntervals().isEmpty()) {
            throw new DataModelException(ErrorMessages.getErrorMsg("No range interval info ", "", this.getLineNumber(), this.getCharPosition(), this.getFileName() + "\""));
        }
        return this.getAscendingRangeIntervals().get(this.getAscendingRangeIntervals().size() - 1).getEndValue();
    }

    public void addRangeRestrictionInterval(YangRangeInterval<T> newInterval) throws DataModelException {
        Preconditions.checkNotNull(newInterval);
        Preconditions.checkNotNull(newInterval.getStartValue());
        if (this.ascendingRangeIntervals == null) {
            this.ascendingRangeIntervals = new LinkedList<YangRangeInterval<T>>();
            this.ascendingRangeIntervals.add(newInterval);
            return;
        }
        T curMaxvalue = this.getMaxRestrictedValue();
        if (newInterval.getStartValue().compareTo(curMaxvalue) < 1) {
            throw new DataModelException(ErrorMessages.getErrorMsg("New added range interval is lesser than the old interval(s) ", "", this.getLineNumber(), this.getCharPosition(), this.getFileName() + "\""));
        }
        this.getAscendingRangeIntervals().add(this.getAscendingRangeIntervals().size(), newInterval);
    }

    boolean isValidValueString(String valueInString) throws DataModelException {
        if (this.getAscendingRangeIntervals() == null || this.getAscendingRangeIntervals().isEmpty()) {
            throw new DataModelException(ErrorMessages.getErrorMsg("Range interval missing in range restriction. ", "", this.getLineNumber(), this.getCharPosition(), this.getFileName() + "\""));
        }
        YangDataTypes type = this.getAscendingRangeIntervals().get(0).getStartValue().getYangType();
        Object value = BuiltInTypeObjectFactory.getDataObjectFromString(valueInString, type);
        for (YangRangeInterval<T> interval : this.getAscendingRangeIntervals()) {
            int rangeStartCompareRes = interval.getStartValue().compareTo(value);
            int rangeEndCompareRes = interval.getEndValue().compareTo(value);
            if (rangeStartCompareRes > 0 || rangeEndCompareRes < 0) continue;
            return true;
        }
        return false;
    }

    boolean isValidInterval(YangRangeInterval rangeInterval, String fileName) throws DataModelException {
        if (this.getAscendingRangeIntervals() == null || this.getAscendingRangeIntervals().isEmpty()) {
            throw new DataModelException(ErrorMessages.getErrorMsg("Range interval missing in range restriction. ", "restriction ranges.", this.getLineNumber(), this.getCharPosition(), fileName + "\""));
        }
        for (YangRangeInterval<T> interval : this.getAscendingRangeIntervals()) {
            int rangeStartCompareRes = interval.getStartValue().compareTo(rangeInterval.getStartValue());
            int rangeEndCompareRes = interval.getEndValue().compareTo(rangeInterval.getEndValue());
            if (rangeStartCompareRes > 0 || rangeEndCompareRes < 0) continue;
            return true;
        }
        throw new DataModelException(ErrorMessages.getErrorMsg("Range interval doesn't fall within the referred restriction ranges ", "restriction ranges.", this.getLineNumber(), this.getCharPosition(), fileName + "\""));
    }

    @Override
    public String getReference() {
        return this.reference;
    }

    @Override
    public void setReference(String ref) {
        this.reference = ref;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public void setDescription(String desc) {
        this.description = desc;
    }

    @Override
    public YangConstructType getYangConstructType() {
        return YangConstructType.RANGE_DATA;
    }

    @Override
    public void validateDataOnEntry() throws DataModelException {
    }

    @Override
    public void validateDataOnExit() throws DataModelException {
    }

    @Override
    public void setAppErrorInfo(YangAppErrorInfo yangAppErrorInfo) {
        this.yangAppErrorInfo = yangAppErrorInfo;
    }

    @Override
    public YangAppErrorInfo getAppErrorInfo() {
        return this.yangAppErrorInfo;
    }
}

