/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.yang.compiler.linker.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.onosproject.yang.compiler.datamodel.LeafRefInvalidHolder;
import org.onosproject.yang.compiler.datamodel.RpcNotificationContainer;
import org.onosproject.yang.compiler.datamodel.YangAtomicPath;
import org.onosproject.yang.compiler.datamodel.YangAugment;
import org.onosproject.yang.compiler.datamodel.YangGrouping;
import org.onosproject.yang.compiler.datamodel.YangImport;
import org.onosproject.yang.compiler.datamodel.YangInclude;
import org.onosproject.yang.compiler.datamodel.YangInput;
import org.onosproject.yang.compiler.datamodel.YangLeaf;
import org.onosproject.yang.compiler.datamodel.YangLeafList;
import org.onosproject.yang.compiler.datamodel.YangLeafRef;
import org.onosproject.yang.compiler.datamodel.YangLeavesHolder;
import org.onosproject.yang.compiler.datamodel.YangModule;
import org.onosproject.yang.compiler.datamodel.YangNode;
import org.onosproject.yang.compiler.datamodel.YangNodeIdentifier;
import org.onosproject.yang.compiler.datamodel.YangOutput;
import org.onosproject.yang.compiler.datamodel.YangSchemaNode;
import org.onosproject.yang.compiler.datamodel.YangSubModule;
import org.onosproject.yang.compiler.datamodel.YangUses;
import org.onosproject.yang.compiler.datamodel.exceptions.ErrorMessages;
import org.onosproject.yang.compiler.linker.exceptions.LinkerException;
import org.onosproject.yang.compiler.linker.impl.PrefixResolverType;
import org.onosproject.yang.compiler.linker.impl.XpathLinkingTypes;

public class YangXpathLinker<T> {
    private List<YangAtomicPath> absPaths = new ArrayList<YangAtomicPath>();
    private YangNode rootNode;
    private Map<YangAtomicPath, PrefixResolverType> prefixResolverTypes;
    private String curPrefix;
    private String constructsParentsPrefix;
    private XpathLinkingTypes linkingType;

    public List<YangAugment> getListOfYangAugment(YangNode node) {
        ArrayList<YangAugment> augments = new ArrayList<YangAugment>();
        for (node = node.getChild(); node != null; node = node.getNextSibling()) {
            if (!(node instanceof YangAugment)) continue;
            augments.add((YangAugment)node);
        }
        return augments;
    }

    T processLeafRefXpathLinking(List<YangAtomicPath> atomicPaths, YangNode root, YangLeafRef leafref, XpathLinkingTypes curLinking) {
        YangNode targetNode;
        this.rootNode = root;
        this.prefixResolverTypes = new HashMap<YangAtomicPath, PrefixResolverType>();
        this.linkingType = curLinking;
        this.parsePrefixResolverList(atomicPaths);
        YangAtomicPath leafRefPath = atomicPaths.get(atomicPaths.size() - 1);
        if (atomicPaths.size() == 1) {
            targetNode = this.getTargetNodeWhenPathSizeIsOne(atomicPaths);
        } else {
            for (YangAtomicPath atomicPath : atomicPaths) {
                if (atomicPath == leafRefPath) continue;
                this.absPaths.add(atomicPath);
            }
            targetNode = this.parseData(root);
        }
        if (targetNode == null) {
            targetNode = this.searchInSubModule(root);
        }
        this.validateInvalidNodesInThePath(leafref);
        if (targetNode != null) {
            YangLeaf targetLeaf = this.searchReferredLeaf(targetNode, leafRefPath.getNodeIdentifier().getName());
            if (targetLeaf == null) {
                YangLeafList targetLeafList = this.searchReferredLeafList(targetNode, leafRefPath.getNodeIdentifier().getName());
                if (targetLeafList != null) {
                    return (T)targetLeafList;
                }
                LinkerException ex = new LinkerException("YANG file error: Unable to find base leaf/leaf-list for given leafref path " + leafref.getPath());
                ex.setCharPosition(leafref.getCharPosition());
                ex.setLine(leafref.getLineNumber());
                ex.setFileName(leafref.getFileName());
                throw ex;
            }
            return (T)targetLeaf;
        }
        return null;
    }

    private void validateInvalidNodesInThePath(YangLeafRef leafref) {
        for (YangAtomicPath absolutePath : leafref.getAtomicPath()) {
            YangNode nodeInPath = absolutePath.getResolvedNode();
            if (!(nodeInPath instanceof LeafRefInvalidHolder)) continue;
            LinkerException ex = new LinkerException("YANG file error: The target node, in the leafref path " + leafref.getPath() + " is invalid.");
            ex.setCharPosition(leafref.getCharPosition());
            ex.setLine(leafref.getLineNumber());
            ex.setFileName(leafref.getFileName());
            throw ex;
        }
    }

    private YangNode getTargetNodeWhenPathSizeIsOne(List<YangAtomicPath> paths) {
        if (paths.get(0).getNodeIdentifier().getPrefix() != null && !paths.get(0).getNodeIdentifier().getPrefix().equals(this.getRootsPrefix(this.rootNode))) {
            return this.getImportedNode(this.rootNode, paths.get(0).getNodeIdentifier());
        }
        return this.rootNode;
    }

    public YangNode processXpathLinking(List<YangAtomicPath> paths, YangNode root, XpathLinkingTypes curLinking) {
        this.absPaths = paths;
        this.rootNode = root;
        this.prefixResolverTypes = new HashMap<YangAtomicPath, PrefixResolverType>();
        this.linkingType = curLinking;
        this.parsePrefixResolverList(paths);
        YangNode targetNode = this.parseData(root);
        if (targetNode == null) {
            targetNode = this.searchInSubModule(root);
        }
        return targetNode;
    }

    private YangLeaf searchReferredLeaf(YangNode targetNode, String leafName) {
        if (!(targetNode instanceof YangLeavesHolder)) {
            throw new LinkerException(ErrorMessages.getErrorMsg("Referred node should be of type leaves holder in ", targetNode.getName(), targetNode.getLineNumber(), targetNode.getCharPosition(), targetNode.getFileName()));
        }
        YangLeavesHolder holder = (YangLeavesHolder)((Object)targetNode);
        List<YangLeaf> leaves = holder.getListOfLeaf();
        if (leaves != null && !leaves.isEmpty()) {
            for (YangLeaf leaf : leaves) {
                if (!leaf.getName().equals(leafName)) continue;
                return leaf;
            }
        }
        return null;
    }

    private YangLeafList searchReferredLeafList(YangNode targetNode, String name) {
        if (!(targetNode instanceof YangLeavesHolder)) {
            throw new LinkerException(ErrorMessages.getErrorMsg("Referred node should be of type leaves holder in ", targetNode.getName(), targetNode.getLineNumber(), targetNode.getCharPosition(), targetNode.getFileName()));
        }
        YangLeavesHolder holder = (YangLeavesHolder)((Object)targetNode);
        List<YangLeafList> leavesList = holder.getListOfLeafList();
        if (leavesList != null && !leavesList.isEmpty()) {
            for (YangLeafList leafList : leavesList) {
                if (!leafList.getName().equals(name)) continue;
                return leafList;
            }
        }
        return null;
    }

    private YangNode parseData(YangNode root) {
        String rootPrefix;
        this.constructsParentsPrefix = rootPrefix = this.getRootsPrefix(root);
        Iterator<YangAtomicPath> pathIterator = this.absPaths.iterator();
        YangAtomicPath path = pathIterator.next();
        if (path.getNodeIdentifier().getPrefix() != null && !path.getNodeIdentifier().getPrefix().equals(rootPrefix)) {
            return this.parsePath(this.getImportedNode(root, path.getNodeIdentifier()));
        }
        return this.parsePath(root);
    }

    public YangNode parsePath(YangNode root) {
        YangNode tempNode = root;
        Stack<YangNode> linkerStack = new Stack<YangNode>();
        Iterator<YangAtomicPath> pathIterator = this.absPaths.iterator();
        YangAtomicPath tempPath = pathIterator.next();
        this.curPrefix = tempPath.getNodeIdentifier().getPrefix();
        int index = 0;
        do {
            YangNodeIdentifier nodeId = tempPath.getNodeIdentifier();
            YangNode tempAugment = tempPath.getNodeIdentifier().getPrefix() == null ? this.resolveIntraFileAugment(tempPath, root) : this.resolveInterFileAugment(tempPath, root, index);
            if (tempAugment != null) {
                linkerStack.push(tempNode);
                tempNode = tempAugment;
            }
            if ((tempNode = this.searchTargetNode(tempNode, nodeId)) == null && !linkerStack.isEmpty()) {
                tempNode = (YangNode)linkerStack.peek();
                linkerStack.pop();
                tempNode = this.searchTargetNode(tempNode, nodeId);
            }
            if (tempNode != null) {
                tempPath.setResolvedNode(tempNode);
                this.validateTempPathNode(tempNode);
            }
            if (index == this.absPaths.size() - 1) break;
            tempPath = pathIterator.next();
        } while (this.validate(tempNode, ++index));
        return tempNode;
    }

    private void validateTempPathNode(YangNode node) {
        if (this.linkingType != XpathLinkingTypes.AUGMENT_LINKING) {
            return;
        }
        if (node instanceof YangGrouping) {
            LinkerException ex = new LinkerException("Augment linking does not support linking when path contains notification/grouping for path: " + this.getAugmentNodeIdentifier(this.absPaths.get(this.absPaths.size() - 1).getNodeIdentifier(), this.absPaths, this.rootNode));
            ex.setFileName(this.rootNode.getFileName());
            throw ex;
        }
    }

    private YangNode resolveIntraFileAugment(YangAtomicPath tempPath, YangNode root) {
        if (this.curPrefix != tempPath.getNodeIdentifier().getPrefix()) {
            root = this.getIncludedNode(this.rootNode, tempPath.getNodeIdentifier().getName());
            if (root == null && (root = this.getIncludedNode(this.rootNode, this.getAugmentNodeIdentifier(tempPath.getNodeIdentifier(), this.absPaths, this.rootNode))) == null) {
                root = this.rootNode;
            }
        } else if (this.curPrefix != null) {
            root = this.getImportedNode(root, tempPath.getNodeIdentifier());
        }
        this.curPrefix = tempPath.getNodeIdentifier().getPrefix();
        YangNode tempAugment = this.getAugment(tempPath.getNodeIdentifier(), root, this.absPaths);
        if (tempAugment == null) {
            tempAugment = this.getAugment(tempPath.getNodeIdentifier(), this.rootNode, this.absPaths);
        }
        return tempAugment;
    }

    private YangNode resolveInterFileAugment(YangAtomicPath tempPath, YangNode root, int size) {
        YangNode tempAugment;
        if (!tempPath.getNodeIdentifier().getPrefix().equals(this.curPrefix)) {
            this.curPrefix = tempPath.getNodeIdentifier().getPrefix();
            root = this.getImportedNode(this.rootNode, tempPath.getNodeIdentifier());
        }
        if ((tempAugment = this.getAugment(tempPath.getNodeIdentifier(), root, this.absPaths)) == null) {
            return this.resolveInterToInterFileAugment(root, size);
        }
        return tempAugment;
    }

    private YangNode resolveInterToInterFileAugment(YangNode root, int size) {
        List<YangAugment> augments = this.getListOfYangAugment(root);
        ArrayList<YangAtomicPath> paths = new ArrayList<YangAtomicPath>();
        for (YangAugment augment : augments) {
            int index = 0;
            for (YangAtomicPath path : augment.getTargetNode()) {
                if (!this.searchForAugmentInImportedNode(path.getNodeIdentifier(), index)) {
                    paths.clear();
                    break;
                }
                paths.add(path);
                ++index;
            }
            if (!paths.isEmpty() && paths.size() == size) {
                return augment;
            }
            paths.clear();
        }
        return null;
    }

    private boolean searchForAugmentInImportedNode(YangNodeIdentifier nodeId, int index) {
        if (index == this.absPaths.size()) {
            return false;
        }
        YangNodeIdentifier tempNodeId = this.absPaths.get(index).getNodeIdentifier();
        return nodeId.getName().equals(tempNodeId.getName());
    }

    private YangNode getAugment(YangNodeIdentifier tempNodeId, YangNode root, List<YangAtomicPath> absPaths) {
        String augmentName = this.getAugmentNodeIdentifier(tempNodeId, absPaths, root);
        if (augmentName != null) {
            return this.searchAugmentNode(root, augmentName);
        }
        return null;
    }

    private YangNode getImportedNode(YangNode root, YangNodeIdentifier nodeId) {
        List<YangImport> importList = root instanceof YangModule ? ((YangModule)root).getImportList() : ((YangSubModule)root).getImportList();
        for (YangImport imported : importList) {
            if (!imported.getPrefixId().equals(nodeId.getPrefix())) continue;
            return imported.getImportedNode();
        }
        if (nodeId.getName() != null && nodeId.getPrefix().equals(this.constructsParentsPrefix)) {
            return this.rootNode;
        }
        return root;
    }

    private YangNode searchInSubModule(YangNode root) {
        List<YangInclude> includeList = root instanceof YangModule ? ((YangModule)root).getIncludeList() : ((YangSubModule)root).getIncludeList();
        for (YangInclude included : includeList) {
            YangNode tempNode = this.parseData(included.getIncludedNode());
            if (tempNode == null) continue;
            return tempNode;
        }
        return null;
    }

    private YangNode getIncludedNode(YangNode root, String tempPathName) {
        List<YangInclude> includeList = root instanceof YangModule ? ((YangModule)root).getIncludeList() : ((YangSubModule)root).getIncludeList();
        for (YangInclude included : includeList) {
            if (!this.verifyChildNode(included.getIncludedNode(), tempPathName)) continue;
            return included.getIncludedNode();
        }
        return null;
    }

    private boolean verifyChildNode(YangNode node, String name) {
        for (node = node.getChild(); node != null; node = node.getNextSibling()) {
            if (!node.getName().equals(name)) continue;
            return true;
        }
        return false;
    }

    private String getAugmentNodeIdentifier(YangNodeIdentifier nodeId, List<YangAtomicPath> absPaths, YangNode root) {
        Iterator<YangAtomicPath> nodeIdIterator = absPaths.iterator();
        StringBuilder builder = new StringBuilder();
        while (nodeIdIterator.hasNext()) {
            YangAtomicPath tempNodeId = nodeIdIterator.next();
            String name = tempNodeId.getNodeIdentifier().getName();
            String prefix = tempNodeId.getNodeIdentifier().getPrefix();
            if (!tempNodeId.getNodeIdentifier().equals(nodeId)) {
                String id;
                PrefixResolverType type = this.prefixResolverTypes.get(tempNodeId);
                switch (type) {
                    case INTER_TO_INTRA: {
                        id = "/" + name;
                        break;
                    }
                    case INTRA_TO_INTER: {
                        if (!this.getRootsPrefix(root).equals(prefix)) {
                            id = "/" + prefix + ":" + name;
                            break;
                        }
                        id = "/" + name;
                        break;
                    }
                    case INTER_TO_INTER: {
                        id = "/" + prefix + ":" + name;
                        break;
                    }
                    case NO_PREFIX_CHANGE_FOR_INTRA: {
                        id = "/" + name;
                        break;
                    }
                    case NO_PREFIX_CHANGE_FOR_INTER: {
                        if (!this.getRootsPrefix(root).equals(prefix)) {
                            id = "/" + prefix + ":" + name;
                            break;
                        }
                        id = "/" + name;
                        break;
                    }
                    default: {
                        id = "/" + name;
                    }
                }
                builder.append(id);
                continue;
            }
            return builder.toString();
        }
        return null;
    }

    private YangNode searchAugmentNode(YangNode root, String augName) {
        YangNode node = root;
        for (node = node.getChild(); node != null; node = node.getNextSibling()) {
            if (!(node instanceof YangAugment)) continue;
            String name = ((YangAugment)node).getPrefixRemovedName();
            if (!node.getName().equals(augName) && !name.equals(augName)) continue;
            return node;
        }
        return null;
    }

    private boolean validate(YangSchemaNode tempNode, int index) {
        int size = this.absPaths.size();
        if (tempNode != null && index != size) {
            return true;
        }
        if (tempNode != null) {
            return false;
        }
        return index != size;
    }

    private YangNode searchTargetNode(YangNode node, YangNodeIdentifier curNodeId) {
        YangNode targetNode;
        if (this.linkingType == XpathLinkingTypes.DEVIATION_LINKING && node instanceof YangLeavesHolder && (targetNode = this.searchTargetLeaf(node, curNodeId)) != null) {
            return targetNode;
        }
        if (node != null) {
            node = node.getChild();
        }
        while (node != null) {
            if (node instanceof YangInput ? curNodeId.getName().equalsIgnoreCase("input") : node instanceof YangOutput && curNodeId.getName().equalsIgnoreCase("output")) {
                return node;
            }
            if (node.getName().equals(curNodeId.getName()) && !(node instanceof YangUses)) {
                return node;
            }
            if (this.linkingType == XpathLinkingTypes.DEVIATION_LINKING && node instanceof YangLeavesHolder && (targetNode = this.searchTargetLeaf(node, curNodeId)) != null) {
                return targetNode;
            }
            node = node.getNextSibling();
        }
        return null;
    }

    private YangNode searchTargetLeaf(YangNode node, YangNodeIdentifier curNodeId) {
        List<YangLeaf> leaves;
        YangLeavesHolder holder = (YangLeavesHolder)((Object)node);
        List<YangLeafList> leavesList = holder.getListOfLeafList();
        if (leavesList != null && !leavesList.isEmpty()) {
            for (YangLeafList leafList : leavesList) {
                if (!leafList.getName().equals(curNodeId.getName())) continue;
                return node;
            }
        }
        if ((leaves = holder.getListOfLeaf()) != null && !leaves.isEmpty()) {
            for (YangLeaf leaf : leaves) {
                if (!leaf.getName().equals(curNodeId.getName())) continue;
                return node;
            }
        }
        return null;
    }

    private String getRootsPrefix(YangNode root) {
        if (root instanceof YangModule) {
            return ((YangModule)root).getPrefix();
        }
        return ((YangSubModule)root).getPrefix();
    }

    private void parsePrefixResolverList(List<YangAtomicPath> absolutePaths) {
        Iterator<YangAtomicPath> pathIterator = absolutePaths.iterator();
        String curPrefix = null;
        while (pathIterator.hasNext()) {
            String prePrefix = curPrefix;
            YangAtomicPath absPath = pathIterator.next();
            curPrefix = absPath.getNodeIdentifier().getPrefix();
            if (curPrefix != null) {
                if (!curPrefix.equals(prePrefix)) {
                    if (prePrefix != null) {
                        this.prefixResolverTypes.put(absPath, PrefixResolverType.INTER_TO_INTER);
                        continue;
                    }
                    this.prefixResolverTypes.put(absPath, PrefixResolverType.INTRA_TO_INTER);
                    continue;
                }
                this.prefixResolverTypes.put(absPath, PrefixResolverType.NO_PREFIX_CHANGE_FOR_INTER);
                continue;
            }
            if (prePrefix != null) {
                this.prefixResolverTypes.put(absPath, PrefixResolverType.INTER_TO_INTRA);
                continue;
            }
            this.prefixResolverTypes.put(absPath, PrefixResolverType.NO_PREFIX_CHANGE_FOR_INTRA);
        }
    }

    void addInModuleIfInput(YangAugment augment, YangNode rootNode) {
        ((RpcNotificationContainer)((Object)rootNode)).addToAugmentList(augment);
    }
}

