/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.yang.compiler.parser.impl.listeners;

import java.util.List;
import org.onosproject.yang.compiler.datamodel.YangAtomicPath;
import org.onosproject.yang.compiler.datamodel.YangDeviation;
import org.onosproject.yang.compiler.datamodel.YangDeviationHolder;
import org.onosproject.yang.compiler.datamodel.YangNode;
import org.onosproject.yang.compiler.datamodel.YangNodeType;
import org.onosproject.yang.compiler.datamodel.exceptions.DataModelException;
import org.onosproject.yang.compiler.datamodel.utils.DataModelUtils;
import org.onosproject.yang.compiler.datamodel.utils.Parsable;
import org.onosproject.yang.compiler.datamodel.utils.YangConstructType;
import org.onosproject.yang.compiler.linker.impl.YangResolutionInfoImpl;
import org.onosproject.yang.compiler.parser.antlrgencode.GeneratedYangParser;
import org.onosproject.yang.compiler.parser.exceptions.ParserException;
import org.onosproject.yang.compiler.parser.impl.TreeWalkListener;
import org.onosproject.yang.compiler.parser.impl.parserutils.ListenerCollisionDetector;
import org.onosproject.yang.compiler.parser.impl.parserutils.ListenerErrorLocation;
import org.onosproject.yang.compiler.parser.impl.parserutils.ListenerErrorMessageConstruction;
import org.onosproject.yang.compiler.parser.impl.parserutils.ListenerErrorType;
import org.onosproject.yang.compiler.parser.impl.parserutils.ListenerUtil;
import org.onosproject.yang.compiler.parser.impl.parserutils.ListenerValidation;

public final class DeviationListener {
    private DeviationListener() {
    }

    public static void processDeviationEntry(TreeWalkListener listener, GeneratedYangParser.DeviationStatementContext ctx) {
        YangDeviation deviation;
        String deviationArg = ListenerUtil.removeQuotesAndHandleConcat(ctx.deviation().getText());
        ListenerValidation.checkStackIsNotEmpty(listener, ListenerErrorType.MISSING_HOLDER, YangConstructType.DEVIATION_DATA, deviationArg, ListenerErrorLocation.ENTRY);
        List<YangAtomicPath> targetNode = ListenerUtil.getValidAbsoluteSchemaNodeId(deviationArg, YangConstructType.DEVIATION_DATA, ctx);
        DeviationListener.validateSubStatementsCardinality(ctx);
        int line = ctx.getStart().getLine();
        int charPositionInLine = ctx.getStart().getCharPositionInLine();
        ListenerCollisionDetector.detectCollidingChildUtil(listener, line, charPositionInLine, deviationArg, YangConstructType.DEVIATION_DATA);
        Parsable curData = listener.getParsedDataStack().peek();
        if (curData instanceof YangDeviationHolder) {
            deviation = new YangDeviation(YangNodeType.DEVIATION_NODE, null);
            deviation.setName(deviationArg);
            deviation.setLineNumber(line);
            deviation.setCharPosition(charPositionInLine);
            deviation.setFileName(listener.getFileName());
            deviation.setTargetNode(targetNode);
            if (!ctx.deviateNotSupportedStatement().isEmpty()) {
                deviation.setDeviateNotSupported(true);
            }
            YangNode curNode = (YangNode)((Object)curData);
            try {
                curNode.addChild(deviation);
                ((YangDeviationHolder)((Object)curNode)).setModuleForDeviation(true);
            }
            catch (DataModelException e) {
                throw new ParserException(ListenerErrorMessageConstruction.constructExtendedListenerErrorMessage(ListenerErrorType.UNHANDLED_PARSED_DATA, YangConstructType.DEVIATION_DATA, deviationArg, ListenerErrorLocation.ENTRY, e.getMessage()));
            }
        } else {
            throw new ParserException(ListenerErrorMessageConstruction.constructListenerErrorMessage(ListenerErrorType.INVALID_HOLDER, YangConstructType.DEVIATION_DATA, deviationArg, ListenerErrorLocation.ENTRY));
        }
        listener.getParsedDataStack().push(deviation);
        YangResolutionInfoImpl<YangDeviation> info = new YangResolutionInfoImpl<YangDeviation>(deviation, deviation.getParent(), line, charPositionInLine);
        DeviationListener.addToResolution(info, ctx);
    }

    public static void processDeviationExit(TreeWalkListener listener, GeneratedYangParser.DeviationStatementContext ctx) {
        ListenerValidation.checkStackIsNotEmpty(listener, ListenerErrorType.MISSING_HOLDER, YangConstructType.DEVIATION_DATA, ctx.deviation().getText(), ListenerErrorLocation.EXIT);
        if (!(listener.getParsedDataStack().peek() instanceof YangDeviation)) {
            throw new ParserException(ListenerErrorMessageConstruction.constructListenerErrorMessage(ListenerErrorType.MISSING_CURRENT_HOLDER, YangConstructType.DEVIATION_DATA, ctx.deviation().getText(), ListenerErrorLocation.EXIT));
        }
        listener.getParsedDataStack().pop();
    }

    private static void validateSubStatementsCardinality(GeneratedYangParser.DeviationStatementContext ctx) {
        ListenerValidation.validateCardinalityMaxOne(ctx.descriptionStatement(), YangConstructType.DESCRIPTION_DATA, YangConstructType.DEVIATION_DATA, ctx.deviation().getText());
        ListenerValidation.validateCardinalityMaxOne(ctx.referenceStatement(), YangConstructType.REFERENCE_DATA, YangConstructType.DEVIATION_DATA, ctx.deviation().getText());
        ListenerValidation.validateCardinalityMaxOne(ctx.deviateNotSupportedStatement(), YangConstructType.DEVIATE_NOT_SUPPORTED, YangConstructType.DEVIATION_DATA, ctx.deviation().getText());
        ListenerValidation.validateCardinalityMutuallyExclusive(ctx.deviateNotSupportedStatement(), YangConstructType.DEVIATE_NOT_SUPPORTED, ctx.deviateAddStatement(), YangConstructType.DEVIATE_ADD, YangConstructType.DEVIATION_DATA, ctx.deviation().getText(), ctx);
        ListenerValidation.validateCardinalityMutuallyExclusive(ctx.deviateNotSupportedStatement(), YangConstructType.DEVIATE_NOT_SUPPORTED, ctx.deviateReplaceStatement(), YangConstructType.DEVIATE_REPLACE, YangConstructType.DEVIATION_DATA, ctx.deviation().getText(), ctx);
        ListenerValidation.validateCardinalityMutuallyExclusive(ctx.deviateNotSupportedStatement(), YangConstructType.DEVIATE_NOT_SUPPORTED, ctx.deviateDeleteStatement(), YangConstructType.DEVIATE_DELETE, YangConstructType.DEVIATION_DATA, ctx.deviation().getText(), ctx);
    }

    private static void addToResolution(YangResolutionInfoImpl<YangDeviation> info, GeneratedYangParser.DeviationStatementContext ctx) {
        try {
            DataModelUtils.addResolutionInfo(info);
        }
        catch (DataModelException e) {
            throw new ParserException(ListenerErrorMessageConstruction.constructExtendedListenerErrorMessage(ListenerErrorType.UNHANDLED_PARSED_DATA, YangConstructType.DEVIATION_DATA, ctx.deviation().getText(), ListenerErrorLocation.EXIT, e.getMessage()));
        }
    }
}

