/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.yang.compiler.parser.impl.listeners;

import org.onosproject.yang.compiler.datamodel.RpcNotificationContainer;
import org.onosproject.yang.compiler.datamodel.YangNode;
import org.onosproject.yang.compiler.datamodel.YangNotification;
import org.onosproject.yang.compiler.datamodel.exceptions.DataModelException;
import org.onosproject.yang.compiler.datamodel.utils.GeneratedLanguage;
import org.onosproject.yang.compiler.datamodel.utils.Parsable;
import org.onosproject.yang.compiler.datamodel.utils.YangConstructType;
import org.onosproject.yang.compiler.parser.antlrgencode.GeneratedYangParser;
import org.onosproject.yang.compiler.parser.exceptions.ParserException;
import org.onosproject.yang.compiler.parser.impl.TreeWalkListener;
import org.onosproject.yang.compiler.parser.impl.parserutils.ListenerCollisionDetector;
import org.onosproject.yang.compiler.parser.impl.parserutils.ListenerErrorLocation;
import org.onosproject.yang.compiler.parser.impl.parserutils.ListenerErrorMessageConstruction;
import org.onosproject.yang.compiler.parser.impl.parserutils.ListenerErrorType;
import org.onosproject.yang.compiler.parser.impl.parserutils.ListenerUtil;
import org.onosproject.yang.compiler.parser.impl.parserutils.ListenerValidation;
import org.onosproject.yang.compiler.translator.tojava.YangDataModelFactory;

public final class NotificationListener {
    private NotificationListener() {
    }

    public static void processNotificationEntry(TreeWalkListener listener, GeneratedYangParser.NotificationStatementContext ctx) {
        YangNotification notification;
        ListenerValidation.checkStackIsNotEmpty(listener, ListenerErrorType.MISSING_HOLDER, YangConstructType.NOTIFICATION_DATA, ctx.identifier().getText(), ListenerErrorLocation.ENTRY);
        String identifier = ListenerUtil.getValidIdentifier(ctx.identifier().getText(), YangConstructType.NOTIFICATION_DATA, ctx);
        NotificationListener.validateSubStatementsCardinality(ctx);
        int line = ctx.getStart().getLine();
        int charPositionInLine = ctx.getStart().getCharPositionInLine();
        ListenerCollisionDetector.detectCollidingChildUtil(listener, line, charPositionInLine, identifier, YangConstructType.NOTIFICATION_DATA);
        Parsable curData = listener.getParsedDataStack().peek();
        if (curData instanceof RpcNotificationContainer) {
            notification = YangDataModelFactory.getYangNotificationNode(GeneratedLanguage.JAVA_GENERATION);
            notification.setName(identifier);
            notification.setLineNumber(ctx.getStart().getLine());
            notification.setCharPosition(ctx.getStart().getCharPositionInLine());
            notification.setFileName(listener.getFileName());
            ((RpcNotificationContainer)((Object)curData)).setNotificationPresenceFlag(true);
            YangNode curNode = (YangNode)((Object)curData);
            try {
                curNode.addChild(notification);
            }
            catch (DataModelException e) {
                throw new ParserException(ListenerErrorMessageConstruction.constructExtendedListenerErrorMessage(ListenerErrorType.UNHANDLED_PARSED_DATA, YangConstructType.NOTIFICATION_DATA, ctx.identifier().getText(), ListenerErrorLocation.ENTRY, e.getMessage()));
            }
        } else {
            throw new ParserException(ListenerErrorMessageConstruction.constructListenerErrorMessage(ListenerErrorType.INVALID_HOLDER, YangConstructType.NOTIFICATION_DATA, ctx.identifier().getText(), ListenerErrorLocation.ENTRY));
        }
        listener.getParsedDataStack().push(notification);
    }

    public static void processNotificationExit(TreeWalkListener listener, GeneratedYangParser.NotificationStatementContext ctx) {
        ListenerValidation.checkStackIsNotEmpty(listener, ListenerErrorType.MISSING_HOLDER, YangConstructType.NOTIFICATION_DATA, ctx.identifier().getText(), ListenerErrorLocation.EXIT);
        if (!(listener.getParsedDataStack().peek() instanceof YangNotification)) {
            throw new ParserException(ListenerErrorMessageConstruction.constructListenerErrorMessage(ListenerErrorType.MISSING_CURRENT_HOLDER, YangConstructType.NOTIFICATION_DATA, ctx.identifier().getText(), ListenerErrorLocation.EXIT));
        }
        listener.getParsedDataStack().pop();
    }

    private static void validateSubStatementsCardinality(GeneratedYangParser.NotificationStatementContext ctx) {
        ListenerValidation.validateCardinalityMaxOne(ctx.statusStatement(), YangConstructType.STATUS_DATA, YangConstructType.NOTIFICATION_DATA, ctx.identifier().getText());
        ListenerValidation.validateCardinalityMaxOne(ctx.descriptionStatement(), YangConstructType.DESCRIPTION_DATA, YangConstructType.NOTIFICATION_DATA, ctx.identifier().getText());
        ListenerValidation.validateCardinalityMaxOne(ctx.referenceStatement(), YangConstructType.REFERENCE_DATA, YangConstructType.NOTIFICATION_DATA, ctx.identifier().getText());
    }
}

