/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.yang.compiler.translator.tojava.javamodel;

import java.io.File;
import java.io.IOException;
import java.util.List;
import org.onosproject.yang.compiler.datamodel.javadatamodel.YangJavaIdentity;
import org.onosproject.yang.compiler.translator.exception.TranslatorException;
import org.onosproject.yang.compiler.translator.tojava.JavaCodeGenerator;
import org.onosproject.yang.compiler.translator.tojava.JavaCodeGeneratorInfo;
import org.onosproject.yang.compiler.translator.tojava.JavaFileInfoTranslator;
import org.onosproject.yang.compiler.translator.tojava.JavaImportData;
import org.onosproject.yang.compiler.translator.tojava.JavaQualifiedTypeInfoTranslator;
import org.onosproject.yang.compiler.translator.tojava.TempJavaCodeFragmentFiles;
import org.onosproject.yang.compiler.translator.tojava.YangJavaModelUtils;
import org.onosproject.yang.compiler.translator.tojava.utils.JavaFileGeneratorUtils;
import org.onosproject.yang.compiler.translator.tojava.utils.JavaIdentifierSyntax;
import org.onosproject.yang.compiler.translator.tojava.utils.MethodsGenerator;
import org.onosproject.yang.compiler.translator.tojava.utils.TranslatorErrorType;
import org.onosproject.yang.compiler.translator.tojava.utils.TranslatorUtils;
import org.onosproject.yang.compiler.utils.io.YangPluginConfig;
import org.onosproject.yang.compiler.utils.io.impl.FileSystemUtil;
import org.onosproject.yang.compiler.utils.io.impl.YangIoUtils;

public class YangJavaIdentityTranslator
extends YangJavaIdentity
implements JavaCodeGeneratorInfo,
JavaCodeGenerator {
    private transient JavaImportData importData;
    private transient TempJavaCodeFragmentFiles tempFileHandle;

    public YangJavaIdentityTranslator() {
        this.setJavaFileInfo(new JavaFileInfoTranslator());
        this.getJavaFileInfo().setGeneratedFileTypes(8207);
        this.importData = new JavaImportData();
    }

    @Override
    public JavaFileInfoTranslator getJavaFileInfo() {
        if (this.javaFileInfo == null) {
            throw new TranslatorException("Missing java info in java identity node " + this.getName());
        }
        return (JavaFileInfoTranslator)this.javaFileInfo;
    }

    @Override
    public void setJavaFileInfo(JavaFileInfoTranslator javaInfo) {
        this.javaFileInfo = javaInfo;
    }

    @Override
    public TempJavaCodeFragmentFiles getTempJavaCodeFragmentFiles() {
        return this.tempFileHandle;
    }

    @Override
    public void setTempJavaCodeFragmentFiles(TempJavaCodeFragmentFiles fileHandle) {
        this.tempFileHandle = fileHandle;
    }

    @Override
    public void generateCodeEntry(YangPluginConfig yangPlugin) throws TranslatorException {
        try {
            YangJavaModelUtils.updatePackageInfo(this, yangPlugin);
            JavaQualifiedTypeInfoTranslator basePkgInfo = new JavaQualifiedTypeInfoTranslator();
            JavaFileInfoTranslator itsInfo = this.getJavaFileInfo();
            String name = itsInfo.getJavaName();
            String className = YangIoUtils.getCapitalCase(name);
            String path = itsInfo.getPackageFilePath();
            JavaIdentifierSyntax.createPackage(this);
            List<String> imports = null;
            if (this.getBaseNode() != null && this.getBaseNode().getReferredIdentity() != null) {
                if (!(this.getBaseNode().getReferredIdentity() instanceof YangJavaIdentityTranslator)) {
                    throw new TranslatorException(TranslatorUtils.getErrorMsg(TranslatorErrorType.FAIL_AT_ENTRY, this, ""));
                }
                YangJavaIdentityTranslator base = (YangJavaIdentityTranslator)this.getBaseNode().getReferredIdentity();
                JavaFileInfoTranslator info = base.getJavaFileInfo();
                String baseClassName = YangIoUtils.getCapitalCase(info.getJavaName());
                String basePkg = info.getPackage();
                basePkgInfo.setClassInfo(baseClassName);
                basePkgInfo.setPkgInfo(basePkg);
                boolean isQualified = this.importData.addImportInfo(basePkgInfo, className, this.javaFileInfo.getPackage());
                if (!isQualified) {
                    imports = this.importData.getImports(true);
                }
            }
            File file = JavaFileGeneratorUtils.getFileObject(path, className, ".java", itsInfo);
            JavaFileGeneratorUtils.initiateJavaFileGeneration(file, 2048, imports, this, className);
            this.addStringMethodsToClass(file, name);
            YangIoUtils.insertDataIntoJavaFile(file, "}");
            YangIoUtils.formatFile(file);
            FileSystemUtil.closeFile(file, false);
        }
        catch (IOException e) {
            throw new TranslatorException(TranslatorUtils.getErrorMsg(TranslatorErrorType.FAIL_AT_EXIT, this, e.getLocalizedMessage()));
        }
    }

    private void addStringMethodsToClass(File file, String className) throws IOException {
        YangIoUtils.insertDataIntoJavaFile(file, MethodsGenerator.getToStringMethodForIdentity(this.getName()));
        YangIoUtils.insertDataIntoJavaFile(file, MethodsGenerator.getFromStringMethodForIdentity(className, this.getName()));
    }

    @Override
    public void generateCodeExit() throws TranslatorException {
    }
}

