/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.yang.compiler.translator.tojava.javamodel;

import java.io.IOException;
import org.onosproject.yang.compiler.datamodel.YangDerivedInfo;
import org.onosproject.yang.compiler.datamodel.YangType;
import org.onosproject.yang.compiler.datamodel.javadatamodel.YangJavaTypeDef;
import org.onosproject.yang.compiler.datamodel.utils.builtindatatype.YangDataTypes;
import org.onosproject.yang.compiler.translator.exception.InvalidNodeForTranslatorException;
import org.onosproject.yang.compiler.translator.exception.TranslatorException;
import org.onosproject.yang.compiler.translator.tojava.JavaCodeGenerator;
import org.onosproject.yang.compiler.translator.tojava.JavaCodeGeneratorInfo;
import org.onosproject.yang.compiler.translator.tojava.JavaFileInfoTranslator;
import org.onosproject.yang.compiler.translator.tojava.TempJavaCodeFragmentFiles;
import org.onosproject.yang.compiler.translator.tojava.YangJavaModelUtils;
import org.onosproject.yang.compiler.utils.io.YangPluginConfig;

public class YangJavaTypeDefTranslator
extends YangJavaTypeDef
implements JavaCodeGeneratorInfo,
JavaCodeGenerator {
    private static final long serialVersionUID = 806201620L;
    private transient TempJavaCodeFragmentFiles tempFileHandle;

    public YangJavaTypeDefTranslator() {
        this.setJavaFileInfo(new JavaFileInfoTranslator());
        this.getJavaFileInfo().setGeneratedFileTypes(64);
    }

    @Override
    public JavaFileInfoTranslator getJavaFileInfo() {
        if (this.javaFileInfo == null) {
            throw new TranslatorException("Missing java info in java datamodel node " + this.getName() + " in " + this.getLineNumber() + " at " + this.getCharPosition() + " in " + this.getFileName());
        }
        return (JavaFileInfoTranslator)this.javaFileInfo;
    }

    @Override
    public void setJavaFileInfo(JavaFileInfoTranslator javaInfo) {
        this.javaFileInfo = javaInfo;
    }

    @Override
    public TempJavaCodeFragmentFiles getTempJavaCodeFragmentFiles() {
        return this.tempFileHandle;
    }

    @Override
    public void setTempJavaCodeFragmentFiles(TempJavaCodeFragmentFiles fileHandle) {
        this.tempFileHandle = fileHandle;
    }

    @Override
    public void generateCodeEntry(YangPluginConfig yangPlugin) throws TranslatorException {
        YangDerivedInfo derivedInfo;
        if (this.getReferredSchema() != null) {
            throw new InvalidNodeForTranslatorException();
        }
        YangType<?> typeInTypeDef = this.getTypeDefBaseType();
        InvalidNodeForTranslatorException exception = new InvalidNodeForTranslatorException();
        exception.setFileName(this.getFileName());
        exception.setCharPosition(this.getCharPosition());
        exception.setLine(this.getLineNumber());
        if (typeInTypeDef.getDataType() == YangDataTypes.DERIVED ? (derivedInfo = (YangDerivedInfo)typeInTypeDef.getDataTypeExtendedInfo()).getEffectiveBuiltInType() == YangDataTypes.LEAFREF : typeInTypeDef.getDataType() == YangDataTypes.LEAFREF) {
            throw exception;
        }
        try {
            YangJavaModelUtils.generateCodeOfNode(this, yangPlugin);
        }
        catch (IOException e) {
            throw new TranslatorException("Failed to prepare generate code entry for typedef node " + this.getName() + "in " + this.getLineNumber() + " at " + this.getCharPosition() + " in " + this.getFileName() + " " + e.getLocalizedMessage());
        }
    }

    @Override
    public void generateCodeExit() throws TranslatorException {
        try {
            YangJavaModelUtils.generateJava(64, this);
        }
        catch (IOException e) {
            throw new TranslatorException("Failed to prepare generate code for typedef node " + this.getName() + "in " + this.getLineNumber() + " at " + this.getCharPosition() + " in " + this.getFileName() + " " + e.getLocalizedMessage());
        }
    }
}

