/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.yang.compiler.translator.tojava.utils;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.onosproject.yang.compiler.datamodel.RpcNotificationContainer;
import org.onosproject.yang.compiler.datamodel.YangDataStructure;
import org.onosproject.yang.compiler.datamodel.YangEnumeration;
import org.onosproject.yang.compiler.datamodel.YangLeavesHolder;
import org.onosproject.yang.compiler.datamodel.YangList;
import org.onosproject.yang.compiler.datamodel.YangNode;
import org.onosproject.yang.compiler.datamodel.YangType;
import org.onosproject.yang.compiler.datamodel.YangTypeDef;
import org.onosproject.yang.compiler.datamodel.YangUnion;
import org.onosproject.yang.compiler.datamodel.utils.builtindatatype.YangDataTypes;
import org.onosproject.yang.compiler.translator.tojava.JavaAttributeInfo;
import org.onosproject.yang.compiler.translator.tojava.JavaCodeGeneratorInfo;
import org.onosproject.yang.compiler.translator.tojava.JavaFileInfoContainer;
import org.onosproject.yang.compiler.translator.tojava.JavaFileInfoTranslator;
import org.onosproject.yang.compiler.translator.tojava.JavaImportData;
import org.onosproject.yang.compiler.translator.tojava.JavaQualifiedTypeInfoTranslator;
import org.onosproject.yang.compiler.translator.tojava.TempJavaCodeFragmentFilesContainer;
import org.onosproject.yang.compiler.translator.tojava.TempJavaEnumerationFragmentFiles;
import org.onosproject.yang.compiler.translator.tojava.TempJavaEventFragmentFiles;
import org.onosproject.yang.compiler.translator.tojava.TempJavaFragmentFiles;
import org.onosproject.yang.compiler.translator.tojava.TempJavaRpcCommandFragmentFiles;
import org.onosproject.yang.compiler.translator.tojava.TempJavaRpcFragmentFiles;
import org.onosproject.yang.compiler.translator.tojava.TempJavaServiceFragmentFiles;
import org.onosproject.yang.compiler.translator.tojava.TempJavaTypeFragmentFiles;
import org.onosproject.yang.compiler.translator.tojava.utils.IndentationType;
import org.onosproject.yang.compiler.translator.tojava.utils.JavaCodeSnippetGen;
import org.onosproject.yang.compiler.translator.tojava.utils.JavaFileGeneratorUtils;
import org.onosproject.yang.compiler.translator.tojava.utils.MethodBodyTypes;
import org.onosproject.yang.compiler.translator.tojava.utils.MethodsGenerator;
import org.onosproject.yang.compiler.translator.tojava.utils.StringGenerator;
import org.onosproject.yang.compiler.translator.tojava.utils.TranslatorUtils;
import org.onosproject.yang.compiler.utils.io.impl.JavaDocGen;
import org.onosproject.yang.compiler.utils.io.impl.YangIoUtils;

public final class JavaFileGenerator {
    private JavaFileGenerator() {
    }

    public static File generateInterfaceFile(File file, List<String> imports, YangNode curNode, boolean attrPresent) throws IOException {
        boolean leavesPresent;
        JavaFileInfoTranslator fileInfo = ((JavaFileInfoContainer)((Object)curNode)).getJavaFileInfo();
        String path = curNode instanceof RpcNotificationContainer ? fileInfo.getPluginConfig().getCodeGenDir() + fileInfo.getPackageFilePath() : fileInfo.getBaseCodeGenPath() + fileInfo.getPackageFilePath();
        String className = YangIoUtils.getCapitalCase(fileInfo.getJavaName());
        if (curNode instanceof YangLeavesHolder) {
            YangLeavesHolder leavesHolder = (YangLeavesHolder)((Object)curNode);
            leavesPresent = JavaFileGenerator.leavesPresent(leavesHolder);
        } else {
            leavesPresent = false;
        }
        JavaFileGeneratorUtils.initiateJavaFileGeneration(file, 1, imports, curNode, className);
        ArrayList<String> methods = new ArrayList<String>();
        if (attrPresent) {
            try {
                if (leavesPresent) {
                    YangIoUtils.insertDataIntoJavaFile(file, MethodsGenerator.getInterfaceLeafIdEnumSignature(className) + YangIoUtils.trimAtLast(YangIoUtils.replaceLast(JavaFileGeneratorUtils.getDataFromTempFileHandle(0x400000, TranslatorUtils.getBeanFiles(curNode), path), ",", ";"), "\n") + StringGenerator.getInterfaceLeafIdEnumMethods());
                }
                YangIoUtils.insertDataIntoJavaFile(file, "\n");
                YangIoUtils.insertDataIntoJavaFile(file, JavaFileGeneratorUtils.getDataFromTempFileHandle(2, TranslatorUtils.getBeanFiles(curNode), path));
                YangIoUtils.insertDataIntoJavaFile(file, JavaFileGeneratorUtils.getDataFromTempFileHandle(8, TranslatorUtils.getBeanFiles(curNode), path));
                YangIoUtils.insertDataIntoJavaFile(file, JavaFileGeneratorUtils.getDataFromTempFileHandle(0x100000, TranslatorUtils.getBeanFiles(curNode), path));
            }
            catch (IOException e) {
                throw new IOException(JavaFileGenerator.getErrorMsg(className, "interface"));
            }
        }
        if (leavesPresent) {
            methods.add(MethodsGenerator.isLeafValueSetInterface());
        }
        for (String method : methods) {
            YangIoUtils.insertDataIntoJavaFile(file, method);
        }
        return file;
    }

    public static File generateKeyClassFile(File file, YangNode curNode) throws IOException {
        JavaFileInfoTranslator fileInfo = ((JavaFileInfoContainer)((Object)curNode)).getJavaFileInfo();
        String className = YangIoUtils.getCapitalCase(fileInfo.getJavaName()) + "Keys";
        ArrayList<String> imports = new ArrayList<String>();
        YangDataStructure data = MethodsGenerator.getYangDataStructure(((YangList)curNode).getCompilerAnnotation());
        if (((YangList)curNode).isConfig() && data == YangDataStructure.MAP) {
            YangNode parent = curNode.getParent();
            JavaImportData importData = ((JavaCodeGeneratorInfo)((Object)parent)).getTempJavaCodeFragmentFiles().getBeanTempFiles().getJavaImportData();
            JavaQualifiedTypeInfoTranslator info = new JavaQualifiedTypeInfoTranslator();
            info.setClassInfo(className);
            info.setPkgInfo(fileInfo.getPackage());
            importData.addImportInfo(info, parent.getJavaClassNameOrBuiltInType(), parent.getJavaPackage());
        }
        List<JavaAttributeInfo> attrs = TempJavaFragmentFiles.getListOfAttributesForKey(curNode);
        for (JavaAttributeInfo attr : attrs) {
            JavaQualifiedTypeInfoTranslator typeInfo = attr.getImportInfo();
            if (!typeInfo.getClassInfo().equals(className) && attr.getImportInfo().getPkgInfo() != null) {
                imports.add(StringGenerator.getImportString(attr.getImportInfo().getPkgInfo(), attr.getImportInfo().getClassInfo()));
                continue;
            }
            attr.setIsQualifiedAccess(true);
        }
        imports.add(StringGenerator.getImportString("org.onosproject.yang.model", "KeyInfo"));
        if (!attrs.isEmpty()) {
            imports.add(StringGenerator.getImportString("java.util", "Objects"));
        }
        JavaFileGeneratorUtils.initiateJavaFileGeneration(file, 4096, imports, curNode, className);
        String pkg = null;
        for (JavaAttributeInfo attr : attrs) {
            if (attr.isQualifiedName()) {
                pkg = attr.getImportInfo().getPkgInfo();
            }
            String attrType = attr.getImportInfo().getClassInfo();
            if (attr.getAttributeType() != null && attr.getAttributeType().getDataType() == YangDataTypes.IDENTITYREF) {
                Object type = attrType;
                if (pkg != null) {
                    type = pkg + "." + attrType;
                }
                attrType = "Class<? extends " + (String)type + ">";
                YangIoUtils.insertDataIntoJavaFile(file, JavaCodeSnippetGen.getJavaAttributeDefinition(null, attrType, attr.getAttributeName(), false, "protected", null));
                continue;
            }
            YangIoUtils.insertDataIntoJavaFile(file, JavaCodeSnippetGen.getJavaAttributeDefinition(pkg, attr.getImportInfo().getClassInfo(), attr.getAttributeName(), false, "protected", null));
        }
        for (JavaAttributeInfo attr : attrs) {
            YangIoUtils.insertDataIntoJavaFile(file, JavaDocGen.getJavaDoc(JavaDocGen.JavaDocType.GETTER_METHOD, attr.getAttributeName(), false, null));
            YangIoUtils.insertDataIntoJavaFile(file, MethodsGenerator.getGetterForClass(attr, 4096));
            YangIoUtils.insertDataIntoJavaFile(file, "\n");
            YangIoUtils.insertDataIntoJavaFile(file, JavaDocGen.getJavaDoc(JavaDocGen.JavaDocType.MANAGER_SETTER_METHOD, attr.getAttributeName(), false, null));
            YangIoUtils.insertDataIntoJavaFile(file, MethodsGenerator.getSetterForClass(attr, 1024));
            YangIoUtils.insertDataIntoJavaFile(file, "\n");
        }
        if (!attrs.isEmpty()) {
            YangIoUtils.insertDataIntoJavaFile(file, MethodsGenerator.getHashCodeMethodOpen());
            StringBuilder builder = new StringBuilder();
            for (JavaAttributeInfo att : attrs) {
                builder.append(MethodsGenerator.getHashCodeMethod(att));
            }
            YangIoUtils.insertDataIntoJavaFile(file, MethodsGenerator.getHashCodeMethodClose(builder.toString()));
            YangIoUtils.insertDataIntoJavaFile(file, MethodsGenerator.getEqualsMethodOpen(className));
            StringBuilder builder2 = new StringBuilder();
            for (JavaAttributeInfo att : attrs) {
                builder2.append(MethodsGenerator.getEqualsMethod(att)).append("\n");
            }
            YangIoUtils.insertDataIntoJavaFile(file, MethodsGenerator.getEqualsMethodClose(builder2.toString()));
        }
        YangIoUtils.insertDataIntoJavaFile(file, "}");
        return file;
    }

    public static File generateDefaultClassFile(File file, YangNode curNode, boolean attrPresent, List<String> imports) throws IOException {
        String path;
        String className;
        boolean leavesPresent;
        JavaFileInfoTranslator fileInfo = ((JavaFileInfoContainer)((Object)curNode)).getJavaFileInfo();
        if (curNode instanceof YangLeavesHolder) {
            YangLeavesHolder leavesHolder = (YangLeavesHolder)((Object)curNode);
            leavesPresent = JavaFileGenerator.leavesPresent(leavesHolder);
        } else {
            leavesPresent = false;
        }
        boolean rootNode = false;
        String opParamClassName = className = YangIoUtils.getCapitalCase(fileInfo.getJavaName());
        String name = "Default" + className;
        if (curNode instanceof RpcNotificationContainer) {
            name = opParamClassName = className + "OpParam";
            rootNode = true;
            path = fileInfo.getPluginConfig().getCodeGenDir() + fileInfo.getPackageFilePath();
        } else {
            path = fileInfo.getBaseCodeGenPath() + fileInfo.getPackageFilePath();
        }
        JavaFileGeneratorUtils.initiateJavaFileGeneration(file, 8, imports, curNode, className);
        ArrayList<String> methods = new ArrayList<String>();
        if (attrPresent) {
            JavaFileGenerator.addDefaultClassAttributeInfo(file, curNode, className, opParamClassName, path, methods, rootNode);
        } else {
            YangIoUtils.insertDataIntoJavaFile(file, "\n");
        }
        methods.add(TranslatorUtils.addDefaultConstructor(curNode, "public", "default"));
        if (leavesPresent) {
            methods.add(StringGenerator.getIsValueLeafSet());
        }
        if (curNode instanceof RpcNotificationContainer) {
            methods.add(MethodsGenerator.getAddAugmentationString());
            methods.add(MethodsGenerator.getRemoveAugmentationString());
            methods.add(MethodsGenerator.getAugmentationsString());
            methods.add(MethodsGenerator.getAugmentationString());
        }
        for (String method : methods) {
            YangIoUtils.insertDataIntoJavaFile(file, method);
        }
        return file;
    }

    private static void addDefaultClassAttributeInfo(File file, YangNode curNode, String className, String opParamClassName, String path, List<String> methods, boolean rootNode) throws IOException {
        try {
            YangIoUtils.insertDataIntoJavaFile(file, JavaFileGeneratorUtils.getDataFromTempFileHandle(1, TranslatorUtils.getBeanFiles(curNode), path));
        }
        catch (IOException e) {
            throw new IOException(JavaFileGenerator.getErrorMsg(className, "impl class"));
        }
        try {
            methods.add(JavaFileGeneratorUtils.getDataFromTempFileHandle(4, TranslatorUtils.getBeanFiles(curNode), path));
            methods.add(JavaFileGeneratorUtils.getDataFromTempFileHandle(16, TranslatorUtils.getBeanFiles(curNode), path));
            methods.add(JavaFileGeneratorUtils.getDataFromTempFileHandle(0x200000, TranslatorUtils.getBeanFiles(curNode), path));
            methods.add(MethodsGenerator.getHashCodeMethodClose(MethodsGenerator.getHashCodeMethodOpen() + JavaFileGeneratorUtils.getDataFromTempFileHandle(64, TranslatorUtils.getBeanFiles(curNode), path).replace("\n", "")));
            if (rootNode) {
                methods.add(MethodsGenerator.getEqualsMethodClose(MethodsGenerator.getEqualsMethodOpen(opParamClassName) + JavaFileGeneratorUtils.getDataFromTempFileHandle(128, TranslatorUtils.getBeanFiles(curNode), path)));
            } else {
                methods.add(MethodsGenerator.getEqualsMethodClose(MethodsGenerator.getEqualsMethodOpen("Default" + className) + JavaFileGeneratorUtils.getDataFromTempFileHandle(128, TranslatorUtils.getBeanFiles(curNode), path)));
            }
            methods.add(MethodsGenerator.getToStringMethodOpen() + JavaFileGeneratorUtils.getDataFromTempFileHandle(256, TranslatorUtils.getBeanFiles(curNode), path) + MethodsGenerator.getToStringMethodClose());
        }
        catch (IOException e) {
            throw new IOException(JavaFileGenerator.getErrorMsg(className, "impl class"));
        }
    }

    public static File generateTypeDefClassFile(File file, YangNode curNode, List<String> imports) throws IOException {
        JavaFileInfoTranslator fileInfo = ((JavaFileInfoContainer)((Object)curNode)).getJavaFileInfo();
        String className = YangIoUtils.getCapitalCase(fileInfo.getJavaName());
        String path = fileInfo.getBaseCodeGenPath() + fileInfo.getPackageFilePath();
        JavaFileGeneratorUtils.initiateJavaFileGeneration(file, className, 64, imports, path);
        ArrayList<String> methods = new ArrayList<String>();
        YangIoUtils.insertDataIntoJavaFile(file, "\n");
        try {
            YangIoUtils.insertDataIntoJavaFile(file, JavaFileGeneratorUtils.getDataFromTempFileHandle(1, TranslatorUtils.getTypeFiles(curNode), path));
        }
        catch (IOException e) {
            throw new IOException(JavaFileGenerator.getErrorMsg(className, "typedef class"));
        }
        methods.add(TranslatorUtils.addDefaultConstructor(curNode, "private", ""));
        try {
            methods.add(JavaFileGeneratorUtils.getDataFromTempFileHandle(1024, TranslatorUtils.getTypeFiles(curNode), path));
            methods.add(JavaFileGeneratorUtils.getDataFromTempFileHandle(512, TranslatorUtils.getTypeFiles(curNode), path));
            methods.add(JavaFileGeneratorUtils.getDataFromTempFileHandle(4, TranslatorUtils.getTypeFiles(curNode), path));
            methods.add(JavaFileGeneratorUtils.getDataFromTempFileHandle(16, TranslatorUtils.getTypeFiles(curNode), path));
            methods.add(MethodsGenerator.getHashCodeMethodClose(MethodsGenerator.getHashCodeMethodOpen() + JavaFileGeneratorUtils.getDataFromTempFileHandle(64, TranslatorUtils.getTypeFiles(curNode), path).replace("\n", "")));
            methods.add(MethodsGenerator.getEqualsMethodClose(MethodsGenerator.getEqualsMethodOpen(className + "") + JavaFileGeneratorUtils.getDataFromTempFileHandle(128, TranslatorUtils.getTypeFiles(curNode), path)));
            JavaFileGenerator.addTypedefToString(curNode, methods);
            JavaCodeGeneratorInfo javaGenInfo = (JavaCodeGeneratorInfo)((Object)curNode);
            methods.add(MethodsGenerator.getFromStringMethodSignature(className) + JavaFileGeneratorUtils.getDataFromTempFileHandle(2048, javaGenInfo.getTempJavaCodeFragmentFiles().getTypeTempFiles(), path) + MethodsGenerator.getFromStringMethodClose());
        }
        catch (IOException e) {
            throw new IOException(JavaFileGenerator.getErrorMsg(className, "typedef class"));
        }
        for (String method : methods) {
            YangIoUtils.insertDataIntoJavaFile(file, method);
        }
        YangIoUtils.insertDataIntoJavaFile(file, "}\n");
        return YangIoUtils.formatFile(file);
    }

    private static void addTypedefToString(YangNode curNode, List<String> methods) {
        List<YangType<?>> types = ((YangTypeDef)curNode).getTypeList();
        YangType<?> type = types.get(0);
        methods.add(MethodsGenerator.getToStringForType(YangIoUtils.getCamelCase(type.getDataTypeName(), null), type));
    }

    public static File generateUnionClassFile(File file, YangNode curNode, List<String> imports) throws IOException {
        String impt;
        JavaAttributeInfo shortAttr;
        JavaAttributeInfo longAttr;
        JavaFileInfoTranslator fileInfo = ((JavaFileInfoContainer)((Object)curNode)).getJavaFileInfo();
        String className = YangIoUtils.getCapitalCase(fileInfo.getJavaName());
        String path = fileInfo.getBaseCodeGenPath() + fileInfo.getPackageFilePath();
        TempJavaTypeFragmentFiles tempFiles = ((JavaCodeGeneratorInfo)((Object)curNode)).getTempJavaCodeFragmentFiles().getTypeTempFiles();
        boolean intConflict = false;
        boolean longConflict = false;
        boolean shortConflict = false;
        JavaAttributeInfo intAttr = tempFiles.getIntAttribute();
        if (intAttr == null) {
            intAttr = tempFiles.getUIntAttribute();
        }
        if ((longAttr = tempFiles.getLongAttribute()) == null) {
            longAttr = tempFiles.getULongAttribute();
        }
        if ((shortAttr = tempFiles.getShortAttribute()) == null) {
            shortAttr = tempFiles.getUInt8Attribute();
        }
        if (intAttr != null) {
            intConflict = intAttr.isIntConflict();
        }
        if (longAttr != null) {
            longConflict = longAttr.isLongConflict();
        }
        if (shortAttr != null) {
            shortConflict = shortAttr.isShortConflict();
        }
        if (longConflict && !imports.contains(impt = tempFiles.getJavaImportData().getBigIntegerImport())) {
            imports.add(impt);
            Collections.sort(imports);
        }
        JavaFileGeneratorUtils.initiateJavaFileGeneration(file, className, 128, imports, path);
        ArrayList<String> methods = new ArrayList<String>();
        try {
            JavaFileGenerator.addUnionClassAttributeInfo(file, curNode, intConflict, longConflict, shortConflict, path, tempFiles);
        }
        catch (IOException e) {
            throw new IOException(JavaFileGenerator.getErrorMsg(className, "union class"));
        }
        methods.add(TranslatorUtils.addDefaultConstructor(curNode, "private", ""));
        try {
            methods.add(JavaFileGeneratorUtils.getDataFromTempFileHandle(1024, TranslatorUtils.getTypeFiles(curNode), path));
            methods.add(JavaFileGeneratorUtils.getDataFromTempFileHandle(512, TranslatorUtils.getTypeFiles(curNode), path));
            methods.add(JavaFileGeneratorUtils.getDataFromTempFileHandle(4, TranslatorUtils.getTypeFiles(curNode), path));
            methods.add(JavaFileGeneratorUtils.getDataFromTempFileHandle(16, TranslatorUtils.getTypeFiles(curNode), path));
            methods.add(MethodsGenerator.getHashCodeMethodClose(MethodsGenerator.getHashCodeMethodOpen() + JavaFileGeneratorUtils.getDataFromTempFileHandle(64, TranslatorUtils.getTypeFiles(curNode), path).replace("\n", "")));
            methods.add(MethodsGenerator.getEqualsMethodClose(MethodsGenerator.getEqualsMethodOpen(className) + JavaFileGeneratorUtils.getDataFromTempFileHandle(128, TranslatorUtils.getTypeFiles(curNode), path)));
            methods.add(MethodsGenerator.getUnionToStringMethod(((YangUnion)curNode).getTypeList()));
            methods.add(MethodsGenerator.getFromStringMethodSignature(className) + JavaFileGeneratorUtils.getDataFromTempFileHandle(2048, TranslatorUtils.getTypeFiles(curNode), path) + MethodsGenerator.getFromStringMethodClose());
            if (intConflict) {
                methods.add(MethodsGenerator.getRangeValidatorMethodForUnion("int"));
            }
            if (longConflict) {
                methods.add(MethodsGenerator.getRangeValidatorMethodForUnion("BigInteger"));
            }
            if (shortConflict && !intConflict) {
                methods.add(MethodsGenerator.getRangeValidatorMethodForUnion("int"));
            }
        }
        catch (IOException e) {
            throw new IOException(JavaFileGenerator.getErrorMsg(className, "union class"));
        }
        for (String method : methods) {
            YangIoUtils.insertDataIntoJavaFile(file, method);
        }
        YangIoUtils.insertDataIntoJavaFile(file, "}\n");
        return YangIoUtils.formatFile(file);
    }

    private static void addUnionClassAttributeInfo(File file, YangNode curNode, boolean intConflict, boolean longConflict, boolean shortConflict, String path, TempJavaTypeFragmentFiles tempFiles) throws IOException {
        if (intConflict) {
            YangIoUtils.insertDataIntoJavaFile(file, JavaCodeSnippetGen.addStaticAttributeIntRange("private", tempFiles.getIntIndex() < tempFiles.getUIntIndex()));
        }
        if (longConflict) {
            YangIoUtils.insertDataIntoJavaFile(file, JavaCodeSnippetGen.addStaticAttributeLongRange("private", tempFiles.getLongIndex() < tempFiles.getULongIndex()));
        }
        if (shortConflict) {
            YangIoUtils.insertDataIntoJavaFile(file, JavaCodeSnippetGen.addStaticAttributeShortRange("private", tempFiles.getShortIndex() < tempFiles.getUInt8Index()));
        }
        YangIoUtils.insertDataIntoJavaFile(file, JavaFileGeneratorUtils.getDataFromTempFileHandle(1, TranslatorUtils.getTypeFiles(curNode), path));
        YangIoUtils.insertDataIntoJavaFile(file, JavaCodeSnippetGen.getSetValueParaForUnionClass());
    }

    public static File generateEnumClassFile(File file, YangNode curNode, List<String> imports) throws IOException {
        JavaFileInfoTranslator fileInfo = ((JavaFileInfoContainer)((Object)curNode)).getJavaFileInfo();
        String className = fileInfo.getJavaName();
        String path = fileInfo.getBaseCodeGenPath() + fileInfo.getPackageFilePath();
        TempJavaEnumerationFragmentFiles enumFile = ((JavaCodeGeneratorInfo)((Object)curNode)).getTempJavaCodeFragmentFiles().getEnumTempFiles();
        JavaImportData data = enumFile.getJavaImportData();
        if (!enumFile.isEnumClass()) {
            imports.add(data.getImportForToBitSet());
            imports.add(data.getImportForPattern());
        }
        JavaFileGeneratorUtils.initiateJavaFileGeneration(file, YangIoUtils.getCapitalCase(className), 32, imports, path);
        try {
            JavaCodeGeneratorInfo javaGenInfo = (JavaCodeGeneratorInfo)((Object)curNode);
            String[] remove = new String[]{",", "\n"};
            YangIoUtils.insertDataIntoJavaFile(file, YangIoUtils.trimAtLast(JavaFileGeneratorUtils.getDataFromTempFileHandle(4096, javaGenInfo.getTempJavaCodeFragmentFiles().getEnumTempFiles(), path), remove) + StringGenerator.signatureClose());
        }
        catch (IOException e) {
            throw new IOException(JavaFileGenerator.getErrorMsg(YangIoUtils.getCapitalCase(className), "enum class"));
        }
        YangIoUtils.insertDataIntoJavaFile(file, "\n");
        YangIoUtils.insertDataIntoJavaFile(file, JavaCodeSnippetGen.getEnumsValueAttribute(className));
        YangIoUtils.insertDataIntoJavaFile(file, MethodsGenerator.getEnumsConstructor(YangIoUtils.getCapitalCase(className)) + "\n");
        YangIoUtils.insertDataIntoJavaFile(file, MethodsGenerator.getEnumsOfValueMethod(className, (YangEnumeration)curNode, MethodBodyTypes.ENUM_METHOD_INT_VALUE));
        YangIoUtils.insertDataIntoJavaFile(file, MethodsGenerator.getEnumsOfValueMethod(className, (YangEnumeration)curNode, MethodBodyTypes.ENUM_METHOD_STRING_VALUE));
        YangIoUtils.insertDataIntoJavaFile(file, JavaDocGen.getJavaDoc(JavaDocGen.JavaDocType.GETTER_METHOD, className, false, null) + MethodsGenerator.getGetter("int", className, 32) + "\n");
        if (!enumFile.isEnumClass()) {
            YangIoUtils.insertDataIntoJavaFile(file, MethodsGenerator.getBitSetEnumClassFromString(YangIoUtils.getCapitalCase(className)));
            YangIoUtils.insertDataIntoJavaFile(file, MethodsGenerator.getBitSetEnumClassToString(YangIoUtils.getCapitalCase(className), (YangEnumeration)curNode));
        } else {
            YangIoUtils.insertDataIntoJavaFile(file, MethodsGenerator.getToStringForEnumClass());
        }
        YangIoUtils.insertDataIntoJavaFile(file, "}\n");
        return YangIoUtils.formatFile(file);
    }

    public static File generateServiceInterfaceFile(File file, YangNode curNode, List<String> imports) throws IOException {
        JavaFileInfoTranslator fileInfo = ((JavaFileInfoContainer)((Object)curNode)).getJavaFileInfo();
        TempJavaServiceFragmentFiles tempFiles = ((JavaCodeGeneratorInfo)((Object)curNode)).getTempJavaCodeFragmentFiles().getServiceTempFiles();
        String className = YangIoUtils.getCapitalCase(fileInfo.getJavaName()) + "Service";
        String path = fileInfo.getBaseCodeGenPath() + fileInfo.getPackageFilePath();
        JavaFileGeneratorUtils.initiateJavaFileGeneration(file, 16, imports, curNode, className);
        ArrayList<String> methods = new ArrayList<String>();
        try {
            if (((JavaCodeGeneratorInfo)((Object)curNode)).getTempJavaCodeFragmentFiles().getServiceTempFiles() != null) {
                JavaCodeGeneratorInfo javaGenInfo = (JavaCodeGeneratorInfo)((Object)curNode);
                methods.add(JavaFileGeneratorUtils.getDataFromTempFileHandle(8192, javaGenInfo.getTempJavaCodeFragmentFiles().getServiceTempFiles(), path));
            }
        }
        catch (IOException e) {
            throw new IOException(JavaFileGenerator.getErrorMsg(className, "rpc class"));
        }
        for (String method : methods) {
            YangIoUtils.insertDataIntoJavaFile(file, method);
        }
        YangIoUtils.insertDataIntoJavaFile(file, "}\n");
        return YangIoUtils.formatFile(file);
    }

    public static void generateEventFile(File file, YangNode curNode, List<String> imports) throws IOException {
        String className = YangIoUtils.getCapitalCase(((JavaFileInfoContainer)((Object)curNode)).getJavaFileInfo().getJavaName()) + "Event";
        TempJavaEventFragmentFiles tempFiles = ((TempJavaCodeFragmentFilesContainer)((Object)curNode)).getTempJavaCodeFragmentFiles().getEventFragmentFiles();
        String path = ((JavaFileInfoContainer)((Object)curNode)).getJavaFileInfo().getBaseCodeGenPath() + ((JavaFileInfoContainer)((Object)curNode)).getJavaFileInfo().getPackageFilePath();
        JavaFileGeneratorUtils.initiateJavaFileGeneration(file, 256, imports, curNode, className);
        try {
            YangIoUtils.insertDataIntoJavaFile(file, JavaCodeSnippetGen.getEventEnumTypeStart() + YangIoUtils.trimAtLast(JavaFileGeneratorUtils.getDataFromTempFileHandle(32768, tempFiles, path), ",") + StringGenerator.methodClose(IndentationType.FOUR_SPACE));
            YangIoUtils.insertDataIntoJavaFile(file, JavaFileGeneratorUtils.getDataFromTempFileHandle(65536, tempFiles, path));
        }
        catch (IOException e) {
            throw new IOException(JavaFileGenerator.getErrorMsg(className, "event class"));
        }
        YangIoUtils.insertDataIntoJavaFile(file, "}\n");
        YangIoUtils.formatFile(file);
    }

    public static void generateEventListenerFile(File file, YangNode curNode, List<String> imports) throws IOException {
        String className = YangIoUtils.getCapitalCase(((JavaFileInfoContainer)((Object)curNode)).getJavaFileInfo().getJavaName()) + "EventListener";
        JavaFileGeneratorUtils.initiateJavaFileGeneration(file, 512, imports, curNode, className);
        YangIoUtils.insertDataIntoJavaFile(file, "}\n");
        YangIoUtils.formatFile(file);
    }

    public static void generateEventSubjectFile(File file, YangNode curNode) throws IOException {
        String className = YangIoUtils.getCapitalCase(((JavaFileInfoContainer)((Object)curNode)).getJavaFileInfo().getJavaName()) + "EventSubject";
        JavaFileGeneratorUtils.initiateJavaFileGeneration(file, 1024, null, curNode, className);
        String path = ((JavaFileInfoContainer)((Object)curNode)).getJavaFileInfo().getBaseCodeGenPath() + ((JavaFileInfoContainer)((Object)curNode)).getJavaFileInfo().getPackageFilePath();
        TempJavaEventFragmentFiles tempFiles = ((TempJavaCodeFragmentFilesContainer)((Object)curNode)).getTempJavaCodeFragmentFiles().getEventFragmentFiles();
        YangIoUtils.insertDataIntoJavaFile(file, "\n");
        try {
            YangIoUtils.insertDataIntoJavaFile(file, JavaFileGeneratorUtils.getDataFromTempFileHandle(131072, tempFiles, path));
            YangIoUtils.insertDataIntoJavaFile(file, JavaFileGeneratorUtils.getDataFromTempFileHandle(262144, tempFiles, path));
            YangIoUtils.insertDataIntoJavaFile(file, JavaFileGeneratorUtils.getDataFromTempFileHandle(524288, tempFiles, path));
        }
        catch (IOException e) {
            throw new IOException(JavaFileGenerator.getErrorMsg(className, "event class"));
        }
        YangIoUtils.insertDataIntoJavaFile(file, "}\n");
        YangIoUtils.formatFile(file);
    }

    private static String getErrorMsg(String className, String fileType) {
        return "No data found in temporary java code fragment files for " + className + " while " + fileType + " file generation.";
    }

    private static boolean leavesPresent(YangLeavesHolder holder) {
        return holder.getListOfLeaf() != null && !holder.getListOfLeaf().isEmpty() || holder.getListOfLeafList() != null && !holder.getListOfLeafList().isEmpty();
    }

    public static File generateRpcHandler(File file, YangNode curNode, List<String> imports) throws IOException {
        JavaFileGeneratorUtils.initiateJavaFileGeneration(file, 8192, imports, curNode, "DefaultRpcHandler");
        YangIoUtils.insertDataIntoJavaFile(file, TempJavaRpcFragmentFiles.getRpcHandlerContents());
        YangIoUtils.insertDataIntoJavaFile(file, "}\n");
        return YangIoUtils.formatFile(file);
    }

    public static File generateRpcExtendedCommand(File file, YangNode curNode, List<String> imports) throws IOException {
        JavaFileGeneratorUtils.initiateJavaFileGeneration(file, 65536, imports, curNode, "RpcExtendedCommand");
        YangIoUtils.insertDataIntoJavaFile(file, TempJavaRpcFragmentFiles.getRpcExtendedCommandContents());
        YangIoUtils.insertDataIntoJavaFile(file, "}\n");
        return YangIoUtils.formatFile(file);
    }

    public static File generateRpcCommand(File file, YangNode curNode, List<String> imports) throws IOException {
        String className = YangIoUtils.getCapitalCase(YangIoUtils.getCamelCase(curNode.getJavaClassNameOrBuiltInType(), null)) + "Command";
        JavaFileGeneratorUtils.initiateJavaFileGeneration(file, 32768, imports, curNode, className);
        YangIoUtils.insertDataIntoJavaFile(file, TempJavaRpcCommandFragmentFiles.getRpcCommandContents(curNode));
        YangIoUtils.insertDataIntoJavaFile(file, "}\n");
        return YangIoUtils.formatFile(file);
    }

    public static File generateRegisterRpc(File file, YangNode curNode, List<String> imports) throws IOException {
        JavaFileGeneratorUtils.initiateJavaFileGeneration(file, 16384, imports, curNode, "RegisterRpc");
        YangIoUtils.insertDataIntoJavaFile(file, TempJavaRpcFragmentFiles.getRegisterRpcContents(curNode));
        YangIoUtils.insertDataIntoJavaFile(file, "}\n");
        return YangIoUtils.formatFile(file);
    }
}

