/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.yang.runtime;

import java.util.LinkedList;
import java.util.List;
import org.onosproject.yang.model.KeyLeaf;
import org.onosproject.yang.model.LeafListKey;
import org.onosproject.yang.model.ListKey;
import org.onosproject.yang.model.ModelException;
import org.onosproject.yang.model.NodeKey;
import org.onosproject.yang.model.ResourceId;
import org.onosproject.yang.model.SchemaId;

public final class ExtResourceIdBldr
extends ResourceId.Builder {
    private List<NodeKey.NodeKeyBuilder> builders = new LinkedList<NodeKey.NodeKeyBuilder>();

    protected void processCurKey() {
        if (this.curKeyBuilder != null) {
            if (this.curKeyBuilder instanceof LeafListKey.LeafListKeyBuilder) {
                throw new ModelException("Leaf must be the terminal node");
            }
            this.builders.add(this.curKeyBuilder);
        }
    }

    public void traveseToParent() {
        if (this.curKeyBuilder != null) {
            this.curKeyBuilder = this.builders.get(this.builders.size() - 1);
            this.builders.remove(this.builders.size() - 1);
        }
    }

    public ResourceId build() {
        return this.getResourceId();
    }

    public ResourceId getResourceId() {
        if (this.curKeyBuilder != null) {
            this.builders.add(this.curKeyBuilder);
        }
        LinkedList<NodeKey> keys = new LinkedList<NodeKey>();
        for (NodeKey.NodeKeyBuilder builder : this.builders) {
            keys.add(builder.build());
        }
        this.nodeKeyList = keys;
        this.builders.remove(this.builders.size() - 1);
        return new ResourceId((ResourceId.Builder)this);
    }

    public ExtResourceIdBldr copyBuilder(ExtResourceIdBldr ridBldr, ResourceId id) {
        List keys = id.nodeKeys();
        for (NodeKey k : keys) {
            SchemaId sId = k.schemaId();
            if (k instanceof ListKey) {
                List kLeaf = ((ListKey)k).keyLeafs();
                for (KeyLeaf kl : kLeaf) {
                    sId = kl.leafSchema();
                    ridBldr.addKeyLeaf(sId.name(), sId.namespace(), kl.leafValue());
                }
                continue;
            }
            if (k instanceof LeafListKey) {
                sId = k.schemaId();
                ridBldr.addLeafListBranchPoint(sId.name(), sId.namespace(), ((LeafListKey)k).value());
                continue;
            }
            ridBldr.addBranchPointSchema(sId.name(), sId.namespace());
        }
        return ridBldr;
    }
}

