/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.yang.runtime.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import org.onosproject.yang.compiler.datamodel.RpcNotificationContainer;
import org.onosproject.yang.compiler.datamodel.TraversalType;
import org.onosproject.yang.compiler.datamodel.YangAugment;
import org.onosproject.yang.compiler.datamodel.YangAugmentableNode;
import org.onosproject.yang.compiler.datamodel.YangCase;
import org.onosproject.yang.compiler.datamodel.YangChoice;
import org.onosproject.yang.compiler.datamodel.YangDerivedInfo;
import org.onosproject.yang.compiler.datamodel.YangLeaf;
import org.onosproject.yang.compiler.datamodel.YangLeafList;
import org.onosproject.yang.compiler.datamodel.YangLeafRef;
import org.onosproject.yang.compiler.datamodel.YangLeavesHolder;
import org.onosproject.yang.compiler.datamodel.YangList;
import org.onosproject.yang.compiler.datamodel.YangNode;
import org.onosproject.yang.compiler.datamodel.YangSchemaNode;
import org.onosproject.yang.compiler.datamodel.YangType;
import org.onosproject.yang.compiler.datamodel.utils.DataModelUtils;
import org.onosproject.yang.compiler.datamodel.utils.builtindatatype.YangDataTypes;
import org.onosproject.yang.model.DataNode;
import org.onosproject.yang.model.InnerNode;
import org.onosproject.yang.model.LeafNode;
import org.onosproject.yang.runtime.RuntimeHelper;
import org.onosproject.yang.runtime.impl.DataTreeNodeInfo;
import org.onosproject.yang.runtime.impl.DefaultYangModelRegistry;
import org.onosproject.yang.runtime.impl.ModelConverterTraversalInfo;
import org.onosproject.yang.runtime.impl.ModelConverterUtil;
import org.onosproject.yang.runtime.impl.ModelConvertorException;

public class DataTreeBuilderHelper {
    private static final String TRUE = "true";
    private static final String IS_LEAF_VALUE_SET_METHOD = "isLeafValueSet";
    private static final String AUGMENTATIONS = "augmentations";
    private static final String FALSE = "false";
    private final DefaultYangModelRegistry reg;
    private DataNode.Builder extBuilder;
    private Object rootObj;
    private YangSchemaNode rootSchema;
    private YangSchemaNode exitBuilderSchema;

    public DataTreeBuilderHelper(DefaultYangModelRegistry reg) {
        this.reg = reg;
    }

    public void setExtBuilder(DataNode.Builder extBuilder) {
        this.extBuilder = extBuilder;
    }

    DataNode.Builder getDataTree(YangSchemaNode curSchema, DataNode.Builder builder, Object obj) {
        this.extBuilder = builder;
        this.rootObj = obj;
        this.rootSchema = curSchema;
        YangNode curNode = (YangNode)curSchema;
        TraversalType curTraversal = TraversalType.ROOT;
        DataTreeNodeInfo listNodeInfo = null;
        DataTreeNodeInfo augmentNodeInfo = null;
        do {
            ModelConverterTraversalInfo traverseInfo;
            YangNode augmentNode;
            if (curTraversal != TraversalType.PARENT || ModelConverterUtil.isMultiInstanceNode(curNode)) {
                if (curTraversal == TraversalType.PARENT && ModelConverterUtil.isMultiInstanceNode(curNode)) {
                    listNodeInfo = this.getCurNodeInfoAndTraverseBack(curNode);
                }
                if (curTraversal == TraversalType.ROOT && !ModelConverterUtil.isAugmentNode(curNode)) {
                    this.processApplicationRootNode();
                } else {
                    Object processedObject = this.processCurSchemaNode(curNode, listNodeInfo);
                    listNodeInfo = null;
                    if (processedObject == null && !ModelConverterUtil.isAugmentNode(curNode)) {
                        ModelConverterTraversalInfo traverseInfo2 = this.getProcessableInfo(curNode);
                        curNode = traverseInfo2.getYangNode();
                        curTraversal = traverseInfo2.getTraverseType();
                        continue;
                    }
                    if (processedObject == null && ModelConverterUtil.isAugmentNode(curNode)) {
                        curTraversal = TraversalType.PARENT;
                    } else if (curTraversal == TraversalType.PARENT && ModelConverterUtil.isMultiInstanceNode(curNode)) {
                        curTraversal = TraversalType.CHILD;
                    }
                }
            }
            if (curTraversal == TraversalType.PARENT && ModelConverterUtil.isAugmentNode(curNode)) {
                curNode = ((YangAugment)curNode).getAugmentedNode();
                augmentNodeInfo = this.getParentInfo();
                curTraversal = TraversalType.CHILD;
            }
            if (curTraversal != TraversalType.PARENT && curNode instanceof YangAugmentableNode && (augmentNode = this.getAugmentInsideSchemaNode(curNode, augmentNodeInfo)) != null) {
                curNode = augmentNode;
                continue;
            }
            if (curTraversal != TraversalType.PARENT && curNode.getChild() != null) {
                augmentNodeInfo = null;
                listNodeInfo = null;
                curTraversal = TraversalType.CHILD;
                if (!ModelConverterUtil.isNonProcessableNode(curNode = curNode.getChild())) continue;
                traverseInfo = this.getProcessableInfo(curNode);
                curNode = traverseInfo.getYangNode();
                curTraversal = traverseInfo.getTraverseType();
                continue;
            }
            if (curNode.getNextSibling() != null) {
                if (ModelConverterUtil.isNodeProcessCompleted(curNode, curTraversal)) break;
                if (ModelConverterUtil.isMultiInstanceNode(curNode)) {
                    listNodeInfo = this.getCurNodeInfoAndTraverseBack(curNode);
                    augmentNodeInfo = null;
                    continue;
                }
                curTraversal = TraversalType.SIBLING;
                augmentNodeInfo = null;
                this.traverseToParent(curNode);
                if (curNode.equals(this.rootSchema)) continue;
                if (curNode instanceof YangAugment) {
                    curTraversal = TraversalType.PARENT;
                    continue;
                }
                if (ModelConverterUtil.isNonProcessableNode(curNode)) {
                    traverseInfo = this.getProcessableInfo(curNode);
                    curNode = traverseInfo.getYangNode();
                    curTraversal = traverseInfo.getTraverseType();
                    continue;
                }
                curNode = curNode.getNextSibling();
                continue;
            }
            if (ModelConverterUtil.isNodeProcessCompleted(curNode, curTraversal)) break;
            if (ModelConverterUtil.isMultiInstanceNode(curNode)) {
                listNodeInfo = this.getCurNodeInfoAndTraverseBack(curNode);
                augmentNodeInfo = null;
                continue;
            }
            curTraversal = TraversalType.PARENT;
            this.traverseToParent(curNode);
            curNode = this.getParentSchemaNode(curNode);
        } while (curNode != null && !curNode.equals(curSchema));
        return this.extBuilder;
    }

    private YangNode getParentSchemaNode(YangNode curNode) {
        if (curNode instanceof YangAugment) {
            return curNode;
        }
        if (!curNode.equals(this.rootSchema)) {
            return curNode.getParent();
        }
        return curNode;
    }

    private void processApplicationRootNode() {
        DataTreeNodeInfo nodeInfo = new DataTreeNodeInfo();
        nodeInfo.setYangObject(this.rootObj);
        if (this.rootSchema instanceof YangList) {
            nodeInfo.type(DataNode.Type.MULTI_INSTANCE_NODE);
        } else {
            nodeInfo.type(DataNode.Type.SINGLE_INSTANCE_NODE);
        }
        this.extBuilder.appInfo((Object)nodeInfo);
        this.exitBuilderSchema = this.rootSchema;
        this.processLeaves((YangNode)this.rootSchema, nodeInfo);
        this.processLeavesList((YangNode)this.rootSchema, nodeInfo);
    }

    private void traverseToParent(YangNode curNode) {
        if (curNode instanceof YangCase || curNode instanceof YangChoice || curNode instanceof YangAugment) {
            return;
        }
        if (!curNode.equals(this.rootSchema)) {
            this.extBuilder = this.extBuilder.exitNode();
        }
    }

    private DataTreeNodeInfo getCurNodeInfoAndTraverseBack(YangNode curNode) {
        DataTreeNodeInfo appInfo = this.getParentInfo();
        if (!curNode.equals(this.rootSchema)) {
            this.extBuilder = this.extBuilder.exitNode();
        }
        return appInfo;
    }

    private YangNode getAugmentInsideSchemaNode(YangNode curNode, DataTreeNodeInfo augmentNodeInfo) {
        if (augmentNodeInfo == null) {
            List<YangAugment> augmentList = ((YangAugmentableNode)((Object)curNode)).getAugmentedInfoList();
            if (DataModelUtils.nonEmpty(augmentList)) {
                DataTreeNodeInfo parentNodeInfo = this.getParentInfo();
                ListIterator<YangAugment> augmentItr = augmentList.listIterator();
                parentNodeInfo.setAugmentIterator(augmentItr);
                return (YangNode)augmentItr.next();
            }
        } else if (augmentNodeInfo.getAugmentIterator() != null && augmentNodeInfo.getAugmentIterator().hasNext()) {
            return augmentNodeInfo.getAugmentIterator().next();
        }
        return null;
    }

    private Object processCurSchemaNode(YangNode curNode, DataTreeNodeInfo listNodeInfo) {
        YangNode augmented;
        DataTreeNodeInfo curNodeInfo = new DataTreeNodeInfo();
        Object nodeObj = null;
        DataTreeNodeInfo parentNodeInfo = this.getParentInfo();
        if (curNode instanceof YangAugment && (augmented = ((YangAugment)curNode).getAugmentedNode()) instanceof YangCase) {
            Object obj;
            String name = augmented.getJavaAttributeName();
            try {
                obj = ModelConverterUtil.getAttributeOfObject(parentNodeInfo.getYangObject(), name);
            }
            catch (NoSuchMethodException e) {
                throw new ModelConvertorException("Not processable case node with augment in data tree");
            }
            parentNodeInfo = new DataTreeNodeInfo();
            parentNodeInfo.setYangObject(obj);
            parentNodeInfo.type(DataNode.Type.SINGLE_INSTANCE_NODE);
        }
        switch (curNode.getYangSchemaNodeType()) {
            case YANG_SINGLE_INSTANCE_NODE: {
                curNodeInfo.type(DataNode.Type.SINGLE_INSTANCE_NODE);
                nodeObj = this.processSingleInstanceNode(curNode, curNodeInfo, parentNodeInfo);
                break;
            }
            case YANG_MULTI_INSTANCE_NODE: {
                curNodeInfo.type(DataNode.Type.MULTI_INSTANCE_NODE);
                nodeObj = this.processMultiInstanceNode(curNode, curNodeInfo, listNodeInfo, parentNodeInfo);
                break;
            }
            case YANG_CHOICE_NODE: {
                nodeObj = this.processChoiceNode(curNode, parentNodeInfo);
                break;
            }
            case YANG_NON_DATA_NODE: {
                if (!(curNode instanceof YangCase)) break;
                nodeObj = this.processCaseNode(curNode, parentNodeInfo);
                break;
            }
            case YANG_AUGMENT_NODE: {
                nodeObj = this.processAugmentNode(curNode, parentNodeInfo);
                break;
            }
            default: {
                throw new ModelConvertorException("Non processable schema node has arrived for adding it in data tree");
            }
        }
        if (nodeObj != null) {
            this.processLeaves(curNode, parentNodeInfo);
            this.processLeavesList(curNode, parentNodeInfo);
        }
        return nodeObj;
    }

    private Object processSingleInstanceNode(YangNode curNode, DataTreeNodeInfo curNodeInfo, DataTreeNodeInfo parentNodeInfo) {
        Object childObj = this.getChildObject(curNode, parentNodeInfo);
        if (childObj != null) {
            curNodeInfo.setYangObject(childObj);
            curNodeInfo.type(DataNode.Type.SINGLE_INSTANCE_NODE);
            this.processChildNode(curNode, curNodeInfo);
        }
        return childObj;
    }

    private Object processMultiInstanceNode(YangNode curNode, DataTreeNodeInfo curNodeInfo, DataTreeNodeInfo listNodeInfo, DataTreeNodeInfo parentNodeInfo) {
        Object childObj = null;
        if (listNodeInfo == null) {
            List childObjList = (List)this.getChildObject(curNode, parentNodeInfo);
            if (DataModelUtils.nonEmpty(childObjList)) {
                Iterator<Object> listItr = childObjList.iterator();
                if (!listItr.hasNext()) {
                    return null;
                }
                childObj = listItr.next();
                curNodeInfo.setListIterator(listItr);
            }
        } else {
            curNodeInfo.setListIterator(listNodeInfo.getListIterator());
            if (listNodeInfo.getListIterator().hasNext()) {
                childObj = listNodeInfo.getListIterator().next();
            }
        }
        if (childObj != null) {
            curNodeInfo.setYangObject(childObj);
            this.processChildNode(curNode, curNodeInfo);
        }
        return childObj;
    }

    Object processChoiceNode(YangNode curNode, DataTreeNodeInfo parentNodeInfo) {
        Object childObj = this.getChildObject(curNode, parentNodeInfo);
        if (childObj != null) {
            Map<String, Object> choiceCaseMap = parentNodeInfo.getChoiceCaseMap();
            if (choiceCaseMap == null) {
                choiceCaseMap = new HashMap<String, Object>();
                parentNodeInfo.setChoiceCaseMap(choiceCaseMap);
            }
            choiceCaseMap.put(curNode.getName(), childObj);
        }
        return childObj;
    }

    Object processCaseNode(YangNode curNode, DataTreeNodeInfo parentNodeInfo) {
        Object childObj = null;
        if (parentNodeInfo.getChoiceCaseMap() != null) {
            childObj = this.getCaseObjectFromChoice(parentNodeInfo, curNode);
        }
        if (childObj != null) {
            parentNodeInfo.setCaseObject(childObj);
        }
        return childObj;
    }

    Object processAugmentNode(YangNode curNode, DataTreeNodeInfo parentNodeInfo) {
        String className = curNode.getJavaClassNameOrBuiltInType();
        String pkgName = curNode.getJavaPackage();
        Object parentObj = ModelConverterUtil.getParentObjectOfNode(parentNodeInfo, curNode.getParent());
        YangNode augmented = ((YangAugment)curNode).getAugmentedNode();
        if (augmented instanceof YangChoice) {
            String name = augmented.getJavaAttributeName();
            try {
                return ModelConverterUtil.getAttributeOfObject(parentNodeInfo.getYangObject(), name);
            }
            catch (NoSuchMethodException e) {
                throw new ModelConvertorException("Not processable case node with augment in data tree");
            }
        }
        try {
            Map augmentMap = (Map)ModelConverterUtil.getAugmentObject(parentObj, AUGMENTATIONS);
            if (augmentMap != null && !augmentMap.isEmpty()) {
                Class<?> moduleClass = ModelConverterUtil.getClassLoaderForAugment(curNode, this.reg);
                if (moduleClass == null) {
                    return null;
                }
                Class<?> augmentClass = moduleClass.getClassLoader().loadClass(pkgName + "." + "Default" + className);
                Object childObj = augmentMap.get(augmentClass);
                parentNodeInfo.setAugmentObject(childObj);
                return childObj;
            }
        }
        catch (ClassNotFoundException | NoSuchMethodException e) {
            throw new ModelConvertorException(e);
        }
        return null;
    }

    private DataTreeNodeInfo getParentInfo() {
        return (DataTreeNodeInfo)this.extBuilder.appInfo();
    }

    Object getChildObject(YangNode curNode, DataTreeNodeInfo parentNodeInfo) {
        String nodeJavaName = curNode.getJavaAttributeName();
        Object parentObj = ModelConverterUtil.getParentObjectOfNode(parentNodeInfo, curNode.getParent());
        try {
            return ModelConverterUtil.getAttributeOfObject(parentObj, nodeJavaName);
        }
        catch (NoSuchMethodException e) {
            throw new ModelConvertorException(e);
        }
    }

    private void processChildNode(YangNode curNode, DataTreeNodeInfo curNodeInfo) {
        if (this.extBuilder == null) {
            InnerNode.Builder builder = InnerNode.builder((String)curNode.getName(), (String)curNode.getNameSpace().getModuleNamespace());
            if (curNode instanceof YangList) {
                builder.type(DataNode.Type.MULTI_INSTANCE_NODE);
            } else {
                builder.type(DataNode.Type.SINGLE_INSTANCE_NODE);
            }
            this.extBuilder = builder;
        } else {
            this.extBuilder = this.extBuilder.createChildBuilder(curNode.getName(), curNode.getNameSpace().getModuleNamespace()).type(curNodeInfo.type());
        }
        this.exitBuilderSchema = curNode;
        this.extBuilder.appInfo((Object)curNodeInfo);
    }

    private void processLeaves(YangNode yangNode, DataTreeNodeInfo info) {
        List<YangLeaf> leavesList;
        if (yangNode instanceof YangLeavesHolder && (leavesList = ((YangLeavesHolder)((Object)yangNode)).getListOfLeaf()) != null) {
            for (YangLeaf yangLeaf : leavesList) {
                Object leafType;
                DataTreeNodeInfo parentInfo = this.getParentInfo();
                if (yangNode instanceof YangAugment && info != null) {
                    parentInfo = info;
                }
                if (parentInfo == null) {
                    parentInfo = info;
                }
                Object parentObj = ModelConverterUtil.getParentObjectOfNode(parentInfo, yangNode);
                try {
                    leafType = ModelConverterUtil.getAttributeOfObject(parentObj, ModelConverterUtil.getJavaName(yangLeaf));
                }
                catch (NoSuchMethodException e) {
                    throw new ModelConvertorException(e);
                }
                this.addLeafWithValue(yangNode, yangLeaf, parentObj, leafType);
            }
        }
    }

    private void processLeavesList(YangNode yangNode, DataTreeNodeInfo info) {
        List<YangLeafList> listOfLeafList;
        if (yangNode instanceof YangLeavesHolder && (listOfLeafList = ((YangLeavesHolder)((Object)yangNode)).getListOfLeafList()) != null) {
            for (YangLeafList yangLeafList : listOfLeafList) {
                this.addToBuilder(yangNode, yangLeafList, info);
            }
        }
    }

    private List<DataNode.Builder> addToBuilder(YangNode yangNode, YangLeafList leafList, DataTreeNodeInfo info) {
        List obj;
        DataTreeNodeInfo dnbNodeInfo = this.getParentInfo();
        if (yangNode instanceof YangAugment && info != null) {
            dnbNodeInfo = info;
        }
        if (dnbNodeInfo == null) {
            dnbNodeInfo = info;
        }
        Object parentObj = ModelConverterUtil.getParentObjectOfNode(dnbNodeInfo, yangNode);
        try {
            obj = (List)ModelConverterUtil.getAttributeOfObject(parentObj, ModelConverterUtil.getJavaName(leafList));
        }
        catch (NoSuchMethodException e) {
            throw new ModelConvertorException(e);
        }
        if (obj != null) {
            return this.addLeafListValue(yangNode, parentObj, leafList, obj);
        }
        return null;
    }

    List<DataNode.Builder> addLeafListValue(YangSchemaNode yangNode, Object parentObj, YangLeafList leafList, List<Object> obj) {
        LinkedHashSet<String> leafListVal = new LinkedHashSet<String>();
        boolean isEmpty = false;
        for (Object object : obj) {
            String val = ModelConverterUtil.getStringFromType(yangNode, parentObj, ModelConverterUtil.getJavaName(leafList), object, leafList.getDataType());
            isEmpty = this.isTypeEmpty(val, leafList.getDataType());
            if (isEmpty) {
                if (!val.equals(TRUE)) break;
                this.addLeafList(leafListVal, leafList);
                break;
            }
            if (val.equals("")) continue;
            leafListVal.add(val);
        }
        if (!isEmpty && !leafListVal.isEmpty()) {
            return this.addLeafList(leafListVal, leafList);
        }
        return null;
    }

    private List<DataNode.Builder> addLeafList(Set<String> leafListVal, YangLeafList leafList) {
        if (this.extBuilder != null) {
            for (String val : leafListVal) {
                LeafNode.Builder leaf = this.extBuilder.createChildBuilder(leafList.getName(), leafList.getNameSpace().getModuleNamespace(), (Object)val);
                leaf.type(DataNode.Type.MULTI_INSTANCE_LEAF_VALUE_NODE);
                leaf.addLeafListValue((Object)val);
                this.extBuilder = leaf.exitNode();
            }
            return null;
        }
        ArrayList<DataNode.Builder> builders = new ArrayList<DataNode.Builder>();
        for (String val : leafListVal) {
            LeafNode.Builder leaf = LeafNode.builder((String)leafList.getName(), (String)leafList.getNameSpace().getModuleNamespace()).value((Object)val);
            leaf.type(DataNode.Type.MULTI_INSTANCE_LEAF_VALUE_NODE);
            leaf.addLeafListValue((Object)val);
            builders.add((DataNode.Builder)leaf);
        }
        return builders;
    }

    private Object getCaseObjectFromChoice(DataTreeNodeInfo parentNodeInfo, YangSchemaNode caseNode) {
        String javaName = RuntimeHelper.getCapitalCase(caseNode.getJavaClassNameOrBuiltInType());
        YangNode parent = ((YangNode)caseNode).getParent();
        String choiceName = parent instanceof YangAugment ? ((YangAugment)parent).getAugmentedNode().getName() : ((YangNode)caseNode).getParent().getName();
        Map<String, Object> mapObj = parentNodeInfo.getChoiceCaseMap();
        Object caseObj = mapObj.get(choiceName);
        Class<?> interfaceClass = ModelConverterUtil.getInterfaceClassFromImplClass(caseObj);
        return interfaceClass.getSimpleName().equals(javaName) ? caseObj : null;
    }

    DataNode.Builder addLeafWithValue(YangSchemaNode holder, YangLeaf yangLeaf, Object parentObj, Object leafType) {
        String fieldValue = null;
        if (ModelConverterUtil.isTypePrimitive(yangLeaf.getDataType())) {
            fieldValue = this.getLeafValueFromValueSetFlag(holder, parentObj, yangLeaf, leafType);
        } else if (leafType != null) {
            fieldValue = ModelConverterUtil.getStringFromType(holder, parentObj, ModelConverterUtil.getJavaName(yangLeaf), leafType, yangLeaf.getDataType());
        }
        if (ModelConverterUtil.nonEmpty(fieldValue)) {
            boolean isEmpty = this.isTypeEmpty(fieldValue, yangLeaf.getDataType());
            if (isEmpty) {
                if (!fieldValue.equals(TRUE)) {
                    return null;
                }
                fieldValue = null;
            }
            return this.createLeafNode(yangLeaf, fieldValue);
        }
        return null;
    }

    private boolean isTypeEmpty(String fieldValue, YangType<?> dataType) {
        if (fieldValue.equals(TRUE) || fieldValue.equals(FALSE)) {
            switch (dataType.getDataType()) {
                case EMPTY: {
                    return true;
                }
                case LEAFREF: {
                    YangLeafRef leafRef = (YangLeafRef)dataType.getDataTypeExtendedInfo();
                    return this.isTypeEmpty(fieldValue, leafRef.getEffectiveDataType());
                }
                case DERIVED: {
                    YangDerivedInfo info = (YangDerivedInfo)dataType.getDataTypeExtendedInfo();
                    YangDataTypes type = info.getEffectiveBuiltInType();
                    return type == YangDataTypes.EMPTY;
                }
            }
            return false;
        }
        return false;
    }

    private DataNode.Builder createLeafNode(YangLeaf yangLeaf, Object val) {
        if (this.extBuilder != null) {
            if (yangLeaf.isKeyLeaf()) {
                this.extBuilder.addKeyLeaf(yangLeaf.getName(), yangLeaf.getNameSpace().getModuleNamespace(), val);
            }
            LeafNode.Builder leaf = this.extBuilder.createChildBuilder(yangLeaf.getName(), yangLeaf.getNameSpace().getModuleNamespace(), val);
            leaf.type(DataNode.Type.SINGLE_INSTANCE_LEAF_VALUE_NODE);
            this.extBuilder = leaf.exitNode();
            return leaf;
        }
        return ((LeafNode.Builder)LeafNode.builder((String)yangLeaf.getName(), (String)yangLeaf.getNameSpace().getModuleNamespace()).type(DataNode.Type.SINGLE_INSTANCE_LEAF_VALUE_NODE)).value(val);
    }

    private String getLeafValueFromValueSetFlag(YangSchemaNode holder, Object parentObj, YangLeaf yangLeaf, Object leafType) {
        String valueOfLeaf;
        try {
            valueOfLeaf = ModelConverterUtil.isValueOrSelectLeafSet(holder, parentObj, ModelConverterUtil.getJavaName(yangLeaf), IS_LEAF_VALUE_SET_METHOD);
        }
        catch (NoSuchMethodException e) {
            throw new ModelConvertorException(e);
        }
        if (valueOfLeaf.equals(TRUE)) {
            return ModelConverterUtil.getStringFromType(holder, parentObj, ModelConverterUtil.getJavaName(yangLeaf), leafType, yangLeaf.getDataType());
        }
        return null;
    }

    private ModelConverterTraversalInfo getProcessableInfo(YangNode curNode) {
        YangNode parent;
        if (curNode.getNextSibling() != null) {
            YangNode sibling = curNode.getNextSibling();
            while (ModelConverterUtil.isNonProcessableNode(sibling)) {
                sibling = sibling.getNextSibling();
            }
            if (sibling != null) {
                return new ModelConverterTraversalInfo(sibling, TraversalType.SIBLING);
            }
        }
        if (!((parent = curNode.getParent()) instanceof RpcNotificationContainer)) {
            return new ModelConverterTraversalInfo(curNode.getParent(), TraversalType.PARENT);
        }
        return new ModelConverterTraversalInfo((YangNode)this.exitBuilderSchema, TraversalType.PARENT);
    }
}

