/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.yang.runtime.impl;

import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import org.onosproject.yang.compiler.datamodel.YangAugment;
import org.onosproject.yang.compiler.datamodel.YangAugmentableNode;
import org.onosproject.yang.compiler.datamodel.YangLeaf;
import org.onosproject.yang.compiler.datamodel.YangLeafList;
import org.onosproject.yang.compiler.datamodel.YangLeavesHolder;
import org.onosproject.yang.compiler.datamodel.YangList;
import org.onosproject.yang.compiler.datamodel.YangNode;
import org.onosproject.yang.compiler.datamodel.YangRpc;
import org.onosproject.yang.compiler.datamodel.YangSchemaNode;
import org.onosproject.yang.compiler.datamodel.YangSchemaNodeType;
import org.onosproject.yang.compiler.datamodel.utils.DataModelUtils;
import org.onosproject.yang.compiler.utils.io.impl.YangIoUtils;
import org.onosproject.yang.model.AtomicPath;
import org.onosproject.yang.model.KeyInfo;
import org.onosproject.yang.model.LeafIdentifier;
import org.onosproject.yang.model.ModelObjectId;
import org.onosproject.yang.model.MultiInstanceLeaf;
import org.onosproject.yang.model.MultiInstanceNode;
import org.onosproject.yang.model.ResourceId;
import org.onosproject.yang.model.SingleInstanceLeaf;
import org.onosproject.yang.runtime.RuntimeHelper;
import org.onosproject.yang.runtime.impl.DefaultYangModelRegistry;
import org.onosproject.yang.runtime.impl.ModelConverterUtil;
import org.onosproject.yang.runtime.impl.ModelConvertorException;

class ModIdToRscIdConverter {
    private YangSchemaNode lastIndexNode;
    private boolean isMoIdWithLeaf;
    private boolean isRpcAdded = true;
    private boolean isInputOrOutput;
    private final DefaultYangModelRegistry reg;

    ModIdToRscIdConverter(DefaultYangModelRegistry registry) {
        this.reg = registry;
    }

    ResourceId fetchResourceId(ModelObjectId id) {
        ResourceId.Builder rid = ResourceId.builder().addBranchPointSchema("/", null);
        if (id == null || id.atomicPaths().isEmpty()) {
            return rid.build();
        }
        List paths = id.atomicPaths();
        AtomicPath path = (AtomicPath)paths.get(0);
        if (path instanceof SingleInstanceLeaf || path instanceof MultiInstanceLeaf) {
            this.isMoIdWithLeaf = true;
            LeafIdentifier identifier = path instanceof SingleInstanceLeaf ? ((SingleInstanceLeaf)path).leafIdentifier() : ((MultiInstanceLeaf)path).leafIdentifier();
            this.lastIndexNode = this.fetchModNodeFromLeaf(identifier.getClass().getName());
            if (this.lastIndexNode != null) {
                this.handleLeafInRid(this.lastIndexNode, id, rid, path);
                return rid.build();
            }
        }
        return this.convertToResourceId(id, this.fetchModuleNode(ModelConverterUtil.fetchPackage(path)), rid);
    }

    YangSchemaNode fetchModNodeFromLeaf(String pkg) {
        String[] array = pkg.split(Pattern.quote("$"));
        return this.reg.getForRegClassName(array[0]);
    }

    YangSchemaNode fetchModuleNode(String pkg) {
        YangSchemaNode modNode;
        int i;
        StringBuilder modPkg = new StringBuilder();
        String[] strArray = pkg.split(Pattern.quote("."));
        for (i = 0; i <= strArray.length - 3; ++i) {
            modPkg.append(strArray[i]).append(".");
        }
        modPkg.deleteCharAt(modPkg.lastIndexOf("."));
        YangNode node = (YangNode)this.reg.getForRegClassQualifiedName(modPkg.toString(), true);
        if (node != null) {
            this.isInputOrOutput = true;
            modNode = node;
            for (node = node.getChild(); node != null; node = node.getNextSibling()) {
                if (!node.getJavaAttributeName().toLowerCase().equals(strArray[i]) || node.getYangSchemaNodeType() == YangSchemaNodeType.YANG_NON_DATA_NODE) continue;
                this.lastIndexNode = node.getChild();
                break;
            }
        } else {
            modPkg.append(".");
            modPkg.append(strArray[i]);
            modNode = this.reg.getForRegClassQualifiedName(modPkg.toString(), false);
        }
        return modNode;
    }

    private ResourceId convertToResourceId(ModelObjectId id, YangSchemaNode modNode, ResourceId.Builder builder) {
        List paths = id.atomicPaths();
        Iterator it = paths.iterator();
        YangSchemaNode curNode = modNode;
        YangSchemaNode preNode = null;
        while (it.hasNext()) {
            YangNode tempNode;
            AtomicPath path = (AtomicPath)it.next();
            String pkg = ModelConverterUtil.fetchPackage(path);
            curNode = curNode instanceof YangAugmentableNode ? ((tempNode = this.fetchFromAugment((YangNode)curNode, pkg, builder)) != null ? tempNode : this.fetchNode(((YangNode)curNode).getChild(), pkg, builder)) : this.fetchNode(((YangNode)curNode).getChild(), pkg, builder);
            if (curNode == null && paths.indexOf(path) == paths.size() - 1) {
                this.handleLeafInRid(preNode, id, builder, path);
            } else if (curNode != null) {
                builder.addBranchPointSchema(curNode.getName(), curNode.getNameSpace().getModuleNamespace());
                if (curNode instanceof YangList) {
                    YangList list = (YangList)curNode;
                    MultiInstanceNode mil = (MultiInstanceNode)path;
                    KeyInfo keyObj = mil.key();
                    Set keys = list.getKeyLeaf();
                    for (String key : keys) {
                        builder.addKeyLeaf(key, list.getNameSpace().getModuleNamespace(), this.getKeyValue(keyObj, key));
                    }
                }
            } else {
                throw new ModelConvertorException("invalid model object id." + id);
            }
            preNode = curNode;
        }
        if (!this.isMoIdWithLeaf) {
            this.lastIndexNode = curNode;
        }
        return builder.build();
    }

    private void handleLeafInRid(YangSchemaNode preNode, ModelObjectId id, ResourceId.Builder builder, AtomicPath path) {
        String pkg = ModelConverterUtil.fetchPackage(path);
        YangSchemaNode curNode = this.fetchLeaf(preNode, pkg);
        if (curNode == null && preNode instanceof YangAugmentableNode) {
            YangAugment augment;
            List<YangAugment> augments = ((YangAugmentableNode)((Object)preNode)).getAugmentedInfoList();
            Iterator<YangAugment> iterator = augments.iterator();
            while (iterator.hasNext() && (curNode = this.fetchLeaf(augment = iterator.next(), pkg)) == null) {
            }
        }
        if (curNode == null) {
            throw new ModelConvertorException("invalid model object id." + id);
        }
        this.isMoIdWithLeaf = true;
        if (curNode instanceof YangLeaf) {
            builder.addBranchPointSchema(curNode.getName(), curNode.getNameSpace().getModuleNamespace());
        } else {
            Object val = ((MultiInstanceLeaf)path).value();
            builder.addLeafListBranchPoint(curNode.getName(), curNode.getNameSpace().getModuleNamespace(), val);
        }
    }

    private String getJavaPkg(YangNode node) {
        return node.getJavaPackage() + "." + "Default" + RuntimeHelper.getCapitalCase(node.getJavaClassNameOrBuiltInType());
    }

    private YangNode fetchFromAugment(YangNode curNode, String pkg, ResourceId.Builder builder) {
        List<YangAugment> augments;
        if (curNode != null && curNode instanceof YangAugmentableNode && DataModelUtils.nonEmpty(augments = ((YangAugmentableNode)((Object)curNode)).getAugmentedInfoList())) {
            for (YangAugment augment : augments) {
                YangNode tempNode = this.fetchNode(augment.getChild(), pkg, builder);
                if (tempNode == null) continue;
                return tempNode;
            }
        }
        return null;
    }

    private Object getKeyValue(Object keys, String keyName) {
        try {
            return ModelConverterUtil.getAttributeOfObject(keys, YangIoUtils.getCamelCase(keyName, null));
        }
        catch (NoSuchMethodException e) {
            throw new ModelConvertorException("invalid key value in model id for list." + keys.getClass().getName());
        }
    }

    private YangNode fetchNode(YangNode node, String pkg, ResourceId.Builder builder) {
        while (node != null) {
            if (node.getYangSchemaNodeType() != YangSchemaNodeType.YANG_NON_DATA_NODE) {
                String java = this.getJavaPkg(node);
                if (java.equals(pkg)) {
                    return node;
                }
                if (node instanceof YangRpc) {
                    if (this.isRpcAdded) {
                        this.isRpcAdded = false;
                        builder.addBranchPointSchema(node.getName(), node.getNameSpace().getModuleNamespace());
                    }
                    node = node.getChild();
                    continue;
                }
                node = node.getNextSibling();
                continue;
            }
            node = node.getNextSibling();
        }
        return null;
    }

    private YangSchemaNode fetchLeaf(YangSchemaNode node, String name) {
        List<YangLeafList> leafLists;
        YangLeavesHolder holder = (YangLeavesHolder)((Object)node);
        List<YangLeaf> leaves = holder.getListOfLeaf();
        if (DataModelUtils.nonEmpty(leaves)) {
            for (YangLeaf leaf : leaves) {
                if (!leaf.getJavaAttributeName().toLowerCase().equals(name)) continue;
                return leaf;
            }
        }
        if (DataModelUtils.nonEmpty(leafLists = holder.getListOfLeafList())) {
            for (YangLeafList leaf : leafLists) {
                if (!leaf.getJavaAttributeName().toLowerCase().equals(name)) continue;
                return leaf;
            }
        }
        return null;
    }

    YangSchemaNode getLastIndexNode() {
        return this.lastIndexNode;
    }

    boolean isMoIdWithLeaf() {
        return this.isMoIdWithLeaf;
    }

    boolean isInputOrOutput() {
        return this.isInputOrOutput;
    }
}

