/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.yang.runtime.impl;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Base64;
import java.util.HashSet;
import java.util.Set;
import org.onosproject.yang.compiler.datamodel.TraversalType;
import org.onosproject.yang.compiler.datamodel.YangAugment;
import org.onosproject.yang.compiler.datamodel.YangCase;
import org.onosproject.yang.compiler.datamodel.YangIdentity;
import org.onosproject.yang.compiler.datamodel.YangIdentityRef;
import org.onosproject.yang.compiler.datamodel.YangLeafRef;
import org.onosproject.yang.compiler.datamodel.YangNode;
import org.onosproject.yang.compiler.datamodel.YangNotification;
import org.onosproject.yang.compiler.datamodel.YangOutput;
import org.onosproject.yang.compiler.datamodel.YangRpc;
import org.onosproject.yang.compiler.datamodel.YangSchemaNode;
import org.onosproject.yang.compiler.datamodel.YangSchemaNodeType;
import org.onosproject.yang.compiler.datamodel.YangType;
import org.onosproject.yang.compiler.datamodel.utils.builtindatatype.YangDataTypes;
import org.onosproject.yang.model.AtomicPath;
import org.onosproject.yang.model.MultiInstanceLeaf;
import org.onosproject.yang.model.MultiInstanceNode;
import org.onosproject.yang.model.SingleInstanceLeaf;
import org.onosproject.yang.model.SingleInstanceNode;
import org.onosproject.yang.runtime.RuntimeHelper;
import org.onosproject.yang.runtime.impl.DataTreeNodeInfo;
import org.onosproject.yang.runtime.impl.DefaultYangModelRegistry;
import org.onosproject.yang.runtime.impl.ModelConvertorException;

final class ModelConverterUtil {
    static final String STR_NULL = "null";
    private static final int ONE = 1;
    private static final String ENUM_LEAF_IDENTIFIER = "$LeafIdentifier";
    private static final Set<YangDataTypes> PRIMITIVE_TYPES = new HashSet<YangDataTypes>(Arrays.asList(YangDataTypes.INT8, YangDataTypes.INT16, YangDataTypes.INT32, YangDataTypes.INT64, YangDataTypes.UINT8, YangDataTypes.UINT16, YangDataTypes.UINT32, YangDataTypes.BOOLEAN, YangDataTypes.EMPTY));
    private static final String TO_STRING = "toString";

    private ModelConverterUtil() {
    }

    static Object getParentObjectOfNode(DataTreeNodeInfo nodeInfo, YangNode yangNode) {
        Object object = yangNode instanceof YangCase ? nodeInfo.getCaseObject() : (yangNode instanceof YangAugment ? nodeInfo.getAugmentObject() : nodeInfo.getYangObject());
        return object;
    }

    static Object getAttributeOfObject(Object nodeObj, String fieldName) throws NoSuchMethodException {
        Class<?> nodeClass = nodeObj.getClass();
        try {
            Method getterMethod = nodeClass.getDeclaredMethod(fieldName, new Class[0]);
            return getterMethod.invoke(nodeObj, new Object[0]);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new ModelConvertorException(e);
        }
    }

    static Object getAugmentObject(Object nodeObj, String fieldName) throws NoSuchMethodException {
        Class<?> nodeClass = nodeObj.getClass().getSuperclass();
        try {
            Method getterMethod = nodeClass.getDeclaredMethod(fieldName, new Class[0]);
            return getterMethod.invoke(nodeObj, new Object[0]);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new ModelConvertorException(e);
        }
    }

    static Object getAttributeFromInheritance(Object childClass, String methodName) {
        Class<?> parentClass = childClass.getClass().getSuperclass();
        try {
            Method getterMethod = parentClass.getDeclaredMethod(methodName, new Class[0]);
            return getterMethod.invoke(childClass, new Object[0]);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new ModelConvertorException(e);
        }
    }

    static Class<?> getInterfaceClassFromImplClass(Object obj) {
        Class<?>[] interfaces = obj.getClass().getInterfaces();
        if (interfaces.length > 1) {
            throw new ModelConvertorException("Implementation class having more than one interface is not handled");
        }
        return interfaces[0];
    }

    static boolean isTypePrimitive(YangType yangType) {
        if (yangType.getDataType() == YangDataTypes.LEAFREF) {
            YangLeafRef leafRef = (YangLeafRef)yangType.getDataTypeExtendedInfo();
            return ModelConverterUtil.isPrimitiveDataType(leafRef.getEffectiveDataType().getDataType());
        }
        return ModelConverterUtil.isPrimitiveDataType(yangType.getDataType());
    }

    static Class<?> getClassLoaderForAugment(YangNode curNode, DefaultYangModelRegistry registry) {
        return registry.getRegisteredClass(curNode.getParent());
    }

    static String isValueOrSelectLeafSet(YangSchemaNode holder, Object nodeObj, String javaName, String methodName) throws NoSuchMethodException {
        Class<?> nodeClass = nodeObj.getClass();
        String enumPackage = holder.getJavaPackage() + "." + RuntimeHelper.getCapitalCase(holder.getJavaClassNameOrBuiltInType()) + ENUM_LEAF_IDENTIFIER;
        ClassLoader classLoader = nodeClass.getClassLoader();
        try {
            Class<?> leafEnum = classLoader.loadClass(enumPackage);
            Method getterMethod = nodeClass.getMethod(methodName, leafEnum);
            Object value = Enum.valueOf(leafEnum, javaName.toUpperCase());
            return String.valueOf(getterMethod.invoke(nodeObj, value));
        }
        catch (ClassNotFoundException | IllegalAccessException | InvocationTargetException e) {
            throw new ModelConvertorException(e);
        }
    }

    static String getStringFromType(YangSchemaNode holder, Object holderObj, String name, Object fieldObj, YangType dataType) {
        if (fieldObj == null) {
            throw new ModelConvertorException("Value of " + holder.getName() + " is null");
        }
        YangDataTypes type = dataType.getDataType();
        switch (type) {
            case INT8: 
            case INT16: 
            case INT32: 
            case INT64: 
            case UINT8: 
            case UINT16: 
            case UINT32: 
            case UINT64: 
            case EMPTY: 
            case STRING: 
            case DECIMAL64: 
            case INSTANCE_IDENTIFIER: 
            case DERIVED: 
            case UNION: 
            case ENUMERATION: 
            case BOOLEAN: {
                return String.valueOf(fieldObj).trim();
            }
            case BITS: {
                return ModelConverterUtil.getBitsValue(holder, holderObj, name, fieldObj).trim();
            }
            case BINARY: {
                return Base64.getEncoder().encodeToString((byte[])fieldObj);
            }
            case IDENTITYREF: {
                YangIdentityRef ir = (YangIdentityRef)dataType.getDataTypeExtendedInfo();
                if (ir.isInGrouping()) {
                    return String.valueOf(fieldObj).trim();
                }
                return ModelConverterUtil.getIdentityRefValue(fieldObj, ir, holderObj);
            }
            case LEAFREF: {
                YangLeafRef leafRef = (YangLeafRef)dataType.getDataTypeExtendedInfo();
                return ModelConverterUtil.getStringFromType(holder, holderObj, name, fieldObj, leafRef.getEffectiveDataType());
            }
        }
        throw new ModelConvertorException("Unsupported data type. Cannot be processed.");
    }

    private static String getBitsValue(YangSchemaNode holder, Object holderObj, String name, Object fieldObj) {
        Class<?> holderClass = holderObj.getClass();
        String interfaceName = holder.getJavaClassNameOrBuiltInType();
        String className = interfaceName.toLowerCase() + "." + RuntimeHelper.getCapitalCase(name);
        String pkgName = holder.getJavaPackage() + "." + className;
        ClassLoader classLoader = holderClass.getClassLoader();
        try {
            Class<?> bitClass = classLoader.loadClass(pkgName);
            Method getterMethod = bitClass.getDeclaredMethod(TO_STRING, fieldObj.getClass());
            return String.valueOf(getterMethod.invoke(null, fieldObj));
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new ModelConvertorException(e);
        }
    }

    private static String getIdentityRefValue(Object fieldObj, YangIdentityRef ir, Object holderObj) {
        YangIdentity id = ir.getReferredIdentity();
        String idName = id.getJavaClassNameOrBuiltInType();
        String idPkg = id.getJavaPackage() + "." + RuntimeHelper.getCapitalCase(idName);
        String methodName = idName + RuntimeHelper.getCapitalCase(TO_STRING);
        Class<?> holderClass = holderObj.getClass();
        ClassLoader classLoader = holderClass.getClassLoader();
        try {
            Class<?> idClass = classLoader.loadClass(idPkg);
            Method method = idClass.getDeclaredMethod(methodName, new Class[0]);
            return String.valueOf(method.invoke(fieldObj, new Object[0])).trim();
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new ModelConvertorException(e);
        }
    }

    private static boolean isPrimitiveDataType(YangDataTypes dataType) {
        return PRIMITIVE_TYPES.contains((Object)dataType);
    }

    static boolean isNonProcessableNode(YangNode yangNode) {
        return yangNode != null && yangNode instanceof YangNotification || yangNode instanceof YangRpc || yangNode instanceof YangAugment;
    }

    static boolean isMultiInstanceNode(YangNode yangNode) {
        return yangNode.getYangSchemaNodeType() == YangSchemaNodeType.YANG_MULTI_INSTANCE_NODE;
    }

    static boolean isAugmentNode(YangNode yangNode) {
        return yangNode.getYangSchemaNodeType() == YangSchemaNodeType.YANG_AUGMENT_NODE;
    }

    static String emptyObjErrMsg(String objName) {
        return "The " + objName + " given for tree creation cannot be null";
    }

    static String getJavaName(Object node) {
        return ((YangSchemaNode)node).getJavaAttributeName();
    }

    static boolean nonEmpty(String str) {
        return str != null && !str.isEmpty();
    }

    static boolean isNodeProcessCompleted(YangNode curNode, TraversalType type) {
        return type == TraversalType.PARENT && curNode instanceof YangNotification || curNode instanceof YangOutput;
    }

    static String fetchPackage(AtomicPath path) {
        switch (path.type()) {
            case SINGLE_INSTANCE_NODE: {
                SingleInstanceNode sin = (SingleInstanceNode)path;
                return sin.container().getName();
            }
            case MULTI_INSTANCE_NODE: {
                MultiInstanceNode min = (MultiInstanceNode)path;
                return min.listClass().getName();
            }
            case SINGLE_INSTANCE_LEAF_VALUE_NODE: {
                SingleInstanceLeaf sil = (SingleInstanceLeaf)path;
                return ModelConverterUtil.getNameWithOutSpecialChar(sil.leafIdentifier().toString().toLowerCase());
            }
            case MULTI_INSTANCE_LEAF_VALUE_NODE: {
                MultiInstanceLeaf mil = (MultiInstanceLeaf)path;
                return ModelConverterUtil.getNameWithOutSpecialChar(mil.leafIdentifier().toString().toLowerCase());
            }
        }
        throw new ModelConvertorException("leaf/leaf-list can't be at this position");
    }

    private static String getNameWithOutSpecialChar(String name) {
        String[] str = name.split("_");
        StringBuilder builder = new StringBuilder();
        for (String s : str) {
            builder.append(s);
        }
        return builder.toString();
    }
}

