/*
 * Copyright 2017-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.ietfl3vpnsvc.rev20160730.ietfl3vpnsvc;

/**
 * Represents the implementation of ospf.
 */
public abstract class Ospf extends RoutingProtocolType {

    /**
     * Returns the attribute ospf.
     *
     * @return ospf value of ospf
     */
    public static String ospfToString() {
        return "ospf";
    }

    /**
     * Returns the object of ospf fromString input String ospf.
     *
     * @param valInString value of input String
     * @return ospf
     */
    public static Class fromString(String valInString) {
        if (valInString.equals("ospf")) {
            return Ospf.class;
        }
        throw new IllegalArgumentException("not a valid input element");
    }
}